/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network.service;

import com.flowpowered.network.Codec;
import com.flowpowered.network.Message;
import com.flowpowered.network.exception.IllegalOpcodeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class CodecLookupService {
    private final ConcurrentMap<Class<? extends Message>, Codec.CodecRegistration> messages;
    private final ConcurrentMap<Integer, Codec> opcodes;
    private final Codec[] opcodeTable;
    private final AtomicInteger nextId;

    public CodecLookupService(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size cannot be less than 0!");
        }
        this.messages = new ConcurrentHashMap<Class<? extends Message>, Codec.CodecRegistration>();
        if (size == 0) {
            this.opcodes = new ConcurrentHashMap<Integer, Codec>();
            this.opcodeTable = null;
        } else {
            this.opcodeTable = new Codec[size];
            this.opcodes = null;
        }
        this.nextId = new AtomicInteger(0);
    }

    public <M extends Message, C extends Codec<? super M>> Codec.CodecRegistration bind(Class<M> messageClazz, Class<C> codecClazz, Integer opcode) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Codec<?> previous;
        Codec codec;
        Codec.CodecRegistration reg = (Codec.CodecRegistration)this.messages.get(messageClazz);
        if (reg != null) {
            return reg;
        }
        try {
            Constructor<C> con = codecClazz.getConstructor(new Class[0]);
            con.setAccessible(true);
            codec = (Codec)con.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Codec could not be created!", e);
        }
        if (opcode != null) {
            if (opcode < 0) {
                throw new IllegalArgumentException("Opcode must either be null or greater than or equal to 0!");
            }
        } else {
            int id;
            try {
                while (this.get(id = this.nextId.getAndIncrement()) != null) {
                }
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new IllegalStateException("Ran out of Ids!", ioobe);
            }
            opcode = id;
        }
        if ((previous = this.get(opcode)) != null && previous.getClass() != codecClazz) {
            throw new IllegalStateException("Trying to bind an opcode where one already exists. New: " + codecClazz.getSimpleName() + " Old: " + previous.getClass().getSimpleName());
        }
        this.put(opcode, codec);
        reg = new Codec.CodecRegistration(opcode, codec);
        this.messages.put(messageClazz, reg);
        return reg;
    }

    private Codec<?> get(int opcode) throws ArrayIndexOutOfBoundsException {
        if (this.opcodeTable != null && this.opcodes == null) {
            return this.opcodeTable[opcode];
        }
        if (this.opcodes != null && this.opcodeTable == null) {
            return (Codec)this.opcodes.get(opcode);
        }
        throw new IllegalStateException("One and only one codec storage system must be in use!");
    }

    private void put(int opcode, Codec<?> codec) {
        if (this.opcodeTable != null && this.opcodes == null) {
            this.opcodeTable[opcode] = codec;
        } else if (this.opcodes != null && this.opcodeTable == null) {
            this.opcodes.put(opcode, codec);
        } else {
            throw new IllegalStateException("One and only one codec storage system must be in use!");
        }
    }

    public Codec<?> find(int opcode) throws IllegalOpcodeException {
        try {
            Codec<?> c = this.get(opcode);
            if (c == null) {
                throw new NullPointerException();
            }
            return c;
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            throw new IllegalOpcodeException("Opcode " + opcode + " is not bound!");
        }
    }

    public <M extends Message> Codec.CodecRegistration find(Class<M> clazz) {
        return (Codec.CodecRegistration)this.messages.get(clazz);
    }

    public String toString() {
        return "CodecLookupService{messages=" + this.messages + ", opcodes=" + this.opcodes + '}';
    }
}

