/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network.protocol.keyed;

import com.flowpowered.network.Codec;
import com.flowpowered.network.Message;
import com.flowpowered.network.MessageHandler;
import com.flowpowered.network.protocol.AbstractProtocol;
import com.flowpowered.network.service.CodecLookupService;
import com.flowpowered.network.service.HandlerLookupService;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;

public abstract class KeyedProtocol
extends AbstractProtocol {
    private final int maxPackets;
    private final ConcurrentMap<String, CodecLookupService> codecLookup;
    private final ConcurrentMap<String, HandlerLookupService> handlerLookup;

    public KeyedProtocol(String name, int maxPackets) {
        super(name);
        this.maxPackets = maxPackets;
        this.codecLookup = new ConcurrentHashMap<String, CodecLookupService>();
        this.handlerLookup = new ConcurrentHashMap<String, HandlerLookupService>();
    }

    public KeyedProtocol(String name, int maxPackets, Logger logger) {
        super(name, logger);
        this.maxPackets = maxPackets;
        this.codecLookup = new ConcurrentHashMap<String, CodecLookupService>();
        this.handlerLookup = new ConcurrentHashMap<String, HandlerLookupService>();
    }

    protected HandlerLookupService getHandlerLookupService(String key) {
        return (HandlerLookupService)this.handlerLookup.get(key);
    }

    protected CodecLookupService getCodecLookupService(String key) {
        return (CodecLookupService)this.codecLookup.get(key);
    }

    public <M extends Message, C extends Codec<? super M>, H extends MessageHandler<?, ? super M>> Codec.CodecRegistration registerMessage(String key, Class<M> message, Class<C> codec, Class<H> handler, Integer opcode) {
        try {
            Codec.CodecRegistration bind;
            HandlerLookupService handlerLookup;
            CodecLookupService codecLookup = (CodecLookupService)this.codecLookup.get(key);
            if (codecLookup == null) {
                codecLookup = new CodecLookupService(this.maxPackets);
                this.codecLookup.put(key, codecLookup);
            }
            if ((handlerLookup = (HandlerLookupService)this.handlerLookup.get(key)) == null) {
                handlerLookup = new HandlerLookupService();
                this.handlerLookup.put(key, handlerLookup);
            }
            if ((bind = codecLookup.bind(message, codec, opcode)) != null && handler != null) {
                handlerLookup.bind(message, handler);
            }
            return bind;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.getLogger().error("Error registering codec " + codec + ": ", (Throwable)e);
            return null;
        }
    }
}

