/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network.processor.simple;

import com.flowpowered.network.processor.MessageProcessor;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public abstract class SimpleMessageProcessor
implements MessageProcessor {
    protected final int capacity;
    private final byte[] decodingByteBuffer;
    private final byte[] encodingByteBuffer;

    public SimpleMessageProcessor(int capacity) {
        this.capacity = capacity;
        this.decodingByteBuffer = new byte[capacity];
        this.encodingByteBuffer = new byte[capacity];
    }

    @Override
    public final synchronized ByteBuf processOutbound(ChannelHandlerContext ctx, ByteBuf input, ByteBuf buffer) {
        int remaining;
        while ((remaining = input.readableBytes()) > 0) {
            int read;
            int clamped = Math.min(remaining, this.capacity);
            input.readBytes(this.encodingByteBuffer, 0, clamped);
            this.writeEncode(this.encodingByteBuffer, clamped);
            while ((read = this.readEncode(this.encodingByteBuffer)) > 0) {
                buffer.writeBytes(this.encodingByteBuffer, 0, read);
            }
        }
        return buffer;
    }

    protected abstract void writeEncode(byte[] var1, int var2);

    protected abstract int readEncode(byte[] var1);

    @Override
    public final synchronized ByteBuf processInbound(ChannelHandlerContext ctx, ByteBuf input, ByteBuf buffer) {
        int remaining;
        while ((remaining = input.readableBytes()) > 0) {
            int read;
            int clamped = Math.min(remaining, this.capacity);
            input.readBytes(this.decodingByteBuffer, 0, clamped);
            this.writeDecode(this.decodingByteBuffer, clamped);
            while ((read = this.readDecode(this.decodingByteBuffer)) > 0) {
                buffer.writeBytes(this.decodingByteBuffer, 0, read);
            }
        }
        return buffer;
    }

    protected abstract void writeDecode(byte[] var1, int var2);

    protected abstract int readDecode(byte[] var1);
}

