/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network;

import com.flowpowered.network.BasicChannelInitializer;
import com.flowpowered.network.ConnectionManager;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;

public abstract class NetworkServer
implements ConnectionManager {
    private final ServerBootstrap bootstrap = new ServerBootstrap();
    private final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();

    public NetworkServer() {
        ((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new BasicChannelInitializer(this)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
    }

    public ChannelFuture bind(final SocketAddress address) {
        return this.bootstrap.bind(address).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> f) throws Exception {
                if (f.isSuccess()) {
                    NetworkServer.this.onBindSuccess(address);
                } else {
                    NetworkServer.this.onBindFailure(address, f.cause());
                }
            }
        });
    }

    public void onBindSuccess(SocketAddress address) {
    }

    public void onBindFailure(SocketAddress address, Throwable t) {
    }

    @Override
    public void shutdown() {
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
    }
}

