/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network;

import com.flowpowered.network.Message;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public interface Codec<T extends Message> {
    public T decode(ByteBuf var1) throws IOException;

    public ByteBuf encode(ByteBuf var1, T var2) throws IOException;

    public static class CodecRegistration {
        private final int opcode;
        private final Codec<?> codec;

        public CodecRegistration(int opcode, Codec<?> codec) {
            this.opcode = opcode;
            this.codec = codec;
        }

        public int getOpcode() {
            return this.opcode;
        }

        public <M extends Message> Codec<M> getCodec() {
            return this.codec;
        }

        public int hashCode() {
            int hash = 5;
            hash = 67 * hash + this.opcode;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CodecRegistration other = (CodecRegistration)obj;
            return this.opcode == other.opcode;
        }
    }
}

