/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.event.helper.ClientReceiveServerMessageEvent;

public class BatchReferenceTag {
    private final String referenceTag;
    private final String batchType;
    private final List<String> batchTypeParameters;
    private final List<ClientReceiveServerMessageEvent> events = new CopyOnWriteArrayList<ClientReceiveServerMessageEvent>();

    public BatchReferenceTag(@NonNull String referenceTag, @NonNull String type, @NonNull List<String> parameters) {
        this.referenceTag = referenceTag;
        this.batchType = type;
        this.batchTypeParameters = Collections.unmodifiableList(parameters);
    }

    public BatchReferenceTag(@NonNull String referenceTag, @NonNull String type) {
        this(referenceTag, type, Collections.emptyList());
    }

    public @NonNull String getReferenceTag() {
        return this.referenceTag;
    }

    public @NonNull String getType() {
        return this.batchType;
    }

    public @NonNull List<String> getParameters() {
        return this.batchTypeParameters;
    }

    public @NonNull List<ClientReceiveServerMessageEvent> getEvents() {
        return Collections.unmodifiableList(new ArrayList<ClientReceiveServerMessageEvent>(this.events));
    }

    public void addEvent(@NonNull ClientReceiveServerMessageEvent event) {
        this.events.add(event);
    }
}

