/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.event.capabilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.CapabilityState;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.event.abstractbase.CapabilityNegotiationResponseEventWithRequestBase;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class CapabilitiesNewSupportedEvent
extends CapabilityNegotiationResponseEventWithRequestBase {
    private final List<CapabilityState> newCapabilities;

    public CapabilitiesNewSupportedEvent(@NonNull Client client, @NonNull ServerMessage sourceMessage, boolean negotiating, @NonNull List<CapabilityState> newCapabilities) {
        super(client, sourceMessage, negotiating);
        Sanity.nullCheck(newCapabilities, "Capabilities list");
        this.newCapabilities = Collections.unmodifiableList(new ArrayList<CapabilityState>(newCapabilities));
    }

    public @NonNull List<CapabilityState> getNewCapabilities() {
        return this.newCapabilities;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("newCapabilities", this.newCapabilities);
    }
}

