/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.event.abstractbase;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.Actor;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.event.abstractbase.ServerMessageEventBase;
import org.kitteh.irc.client.library.event.helper.ActorEvent;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public abstract class ActorEventBase<A extends Actor>
extends ServerMessageEventBase
implements ActorEvent<A> {
    private final A actor;

    protected ActorEventBase(@NonNull Client client, @NonNull ServerMessage sourceMessage, @NonNull A actor) {
        super(client, sourceMessage);
        Sanity.nullCheck(actor, "Actor");
        Sanity.truthiness(actor.getClient() == client, "Actor must be from given Client");
        this.actor = actor;
    }

    @Override
    public final @NonNull A getActor() {
        return this.actor;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("actor", this.actor);
    }
}

