/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.element.isupport;

import java.util.Collections;
import java.util.HashSet;
import java.util.OptionalInt;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.element.DefaultISupportParameter;
import org.kitteh.irc.client.library.element.ISupportParameter;
import org.kitteh.irc.client.library.util.CIKeyMap;
import org.kitteh.irc.client.library.util.Pair;

public class DefaultISupportTargMax
extends DefaultISupportParameter
implements ISupportParameter.TargMax {
    private final CIKeyMap<Pair<String, OptionalInt>> map;

    public DefaultISupportTargMax(@NonNull Client client, @NonNull String name, @Nullable String value) {
        super(client, name, value);
        this.map = new CIKeyMap(client);
        if (value != null) {
            for (String string : value.split(",")) {
                String[] parts = string.split(":");
                this.map.put(parts[0], Pair.of(parts[0], parts.length == 1 ? OptionalInt.empty() : OptionalInt.of(Integer.parseInt(parts[1]))));
            }
        }
    }

    @Override
    public @NonNull Set<Pair<String, OptionalInt>> getEntries() {
        return Collections.unmodifiableSet(new HashSet<Pair<String, OptionalInt>>(this.map.values()));
    }

    @Override
    public @NonNull OptionalInt getMax(@NonNull String command) {
        Pair<String, OptionalInt> pair = this.map.get(command);
        return pair == null ? OptionalInt.empty() : pair.getRight();
    }
}

