/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.utils.AttributedString;
import org.jline.utils.InfoCmp;

public class Status {
    protected final AbstractTerminal terminal;
    protected final boolean supported;
    protected List<AttributedString> oldLines = Collections.emptyList();
    protected List<AttributedString> linesToRestore = Collections.emptyList();
    protected int rows;
    protected int columns;
    protected boolean force;
    protected boolean suspended = false;

    public static Status getStatus(Terminal terminal) {
        return Status.getStatus(terminal, true);
    }

    public static Status getStatus(Terminal terminal, boolean create) {
        return terminal instanceof AbstractTerminal ? ((AbstractTerminal)terminal).getStatus(create) : null;
    }

    public Status(AbstractTerminal terminal) {
        this.terminal = Objects.requireNonNull(terminal, "terminal can not be null");
        boolean bl = this.supported = terminal.getStringCapability(InfoCmp.Capability.change_scroll_region) != null && terminal.getStringCapability(InfoCmp.Capability.save_cursor) != null && terminal.getStringCapability(InfoCmp.Capability.restore_cursor) != null && terminal.getStringCapability(InfoCmp.Capability.cursor_address) != null;
        if (this.supported) {
            this.resize();
        }
    }

    public void resize() {
        Size size = this.terminal.getSize();
        this.rows = size.getRows();
        this.columns = size.getColumns();
        this.force = true;
    }

    public void reset() {
        this.force = true;
    }

    public void hardReset() {
        if (this.suspended) {
            return;
        }
        ArrayList<AttributedString> lines = new ArrayList<AttributedString>(this.oldLines);
        this.update(null);
        this.update(lines);
    }

    public void redraw() {
        if (this.suspended) {
            return;
        }
        this.update(this.oldLines);
    }

    public void update(List<AttributedString> lines) {
        int i;
        if (!this.supported) {
            return;
        }
        if (lines == null) {
            lines = Collections.emptyList();
        }
        if (this.suspended) {
            this.linesToRestore = new ArrayList<AttributedString>(lines);
            return;
        }
        if (this.oldLines.equals(lines) && !this.force) {
            return;
        }
        int nb = lines.size() - this.oldLines.size();
        if (nb > 0) {
            for (i = 0; i < nb; ++i) {
                this.terminal.puts(InfoCmp.Capability.cursor_down, new Object[0]);
            }
            for (i = 0; i < nb; ++i) {
                this.terminal.puts(InfoCmp.Capability.cursor_up, new Object[0]);
            }
        }
        this.terminal.puts(InfoCmp.Capability.save_cursor, new Object[0]);
        this.terminal.puts(InfoCmp.Capability.cursor_address, this.rows - lines.size(), 0);
        this.terminal.puts(InfoCmp.Capability.clr_eos, new Object[0]);
        for (i = 0; i < lines.size(); ++i) {
            this.terminal.puts(InfoCmp.Capability.cursor_address, this.rows - lines.size() + i, 0);
            lines.get(i).columnSubSequence(0, this.columns).print(this.terminal);
        }
        this.terminal.puts(InfoCmp.Capability.change_scroll_region, 0, this.rows - 1 - lines.size());
        this.terminal.puts(InfoCmp.Capability.restore_cursor, new Object[0]);
        this.terminal.flush();
        this.oldLines = new ArrayList<AttributedString>(lines);
        this.force = false;
    }

    public void suspend() {
        if (this.suspended) {
            return;
        }
        this.linesToRestore = new ArrayList<AttributedString>(this.oldLines);
        this.update(null);
        this.suspended = true;
    }

    public void restore() {
        if (!this.suspended) {
            return;
        }
        this.suspended = false;
        this.update(this.linesToRestore);
        this.linesToRestore = Collections.emptyList();
    }

    public int size() {
        return this.oldLines.size();
    }
}

