/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.text.AbstractComponent;
import net.kyori.text.AbstractComponentBuilder;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import net.kyori.text.format.Style;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class TextComponentImpl
extends AbstractComponent
implements TextComponent {
    static final TextComponent EMPTY = TextComponent.of("");
    static final TextComponent NEWLINE = TextComponent.of("\n");
    static final TextComponent SPACE = TextComponent.of(" ");
    private final String content;

    protected TextComponentImpl(@NonNull List<Component> children, @NonNull Style style, @NonNull String content) {
        super(children, style);
        this.content = content;
    }

    @Override
    public @NonNull String content() {
        return this.content;
    }

    @Override
    public @NonNull TextComponent content(@NonNull String content) {
        return new TextComponentImpl(this.children, this.style, Objects.requireNonNull(content, "content"));
    }

    @Override
    public @NonNull TextComponent children(@NonNull List<Component> children) {
        return new TextComponentImpl(children, this.style, this.content);
    }

    @Override
    public @NonNull TextComponent style(@NonNull Style style) {
        return new TextComponentImpl(this.children, style, this.content);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextComponentImpl)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        TextComponentImpl component = (TextComponentImpl)other;
        return Objects.equals(this.content, component.content);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.content);
    }

    @Override
    protected void populateToString(@NonNull Map<String, Object> builder) {
        builder.put("content", this.content);
    }

    @Override
    public @NonNull TextComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static class BuilderImpl
    extends AbstractComponentBuilder<TextComponent, TextComponent.Builder>
    implements TextComponent.Builder {
        private String content = "";

        BuilderImpl() {
        }

        BuilderImpl(@NonNull TextComponent component) {
            super(component);
            this.content = component.content();
        }

        @Override
        public @NonNull TextComponent.Builder content(@NonNull String content) {
            this.content = Objects.requireNonNull(content, "content");
            return this;
        }

        @Override
        public @NonNull TextComponentImpl build() {
            return new TextComponentImpl(this.children, this.buildStyle(), this.content);
        }
    }
}

