/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.adapter.bukkit;

import com.google.gson.JsonDeserializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.kyori.text.Component;
import net.kyori.text.adapter.bukkit.Adapter;
import net.kyori.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

final class CraftBukkitAdapter
implements Adapter {
    private static final Binding REFLECTION_BINDINGS = CraftBukkitAdapter.load();

    CraftBukkitAdapter() {
    }

    private static Binding load() {
        try {
            Constructor<?> titlePacketConstructor;
            Class<?> titlePacketClassAction;
            Class<?> server = Bukkit.getServer().getClass();
            if (!CraftBukkitAdapter.isCompatibleServer(server)) {
                throw new UnsupportedOperationException("Incompatible server version");
            }
            String serverVersion = CraftBukkitAdapter.maybeVersion(server.getPackage().getName().substring("org.bukkit.craftbukkit".length()));
            Class<?> craftPlayerClass = CraftBukkitAdapter.craftBukkitClass(serverVersion, "entity.CraftPlayer");
            Method getHandleMethod = craftPlayerClass.getMethod("getHandle", new Class[0]);
            Class<?> entityPlayerClass = getHandleMethod.getReturnType();
            Field playerConnectionField = entityPlayerClass.getField("playerConnection");
            Class<?> playerConnectionClass = playerConnectionField.getType();
            Class<?> packetClass = CraftBukkitAdapter.minecraftClass(serverVersion, "Packet");
            Method sendPacketMethod = playerConnectionClass.getMethod("sendPacket", packetClass);
            Class<?> baseComponentClass = CraftBukkitAdapter.minecraftClass(serverVersion, "IChatBaseComponent");
            Class<?> chatPacketClass = CraftBukkitAdapter.minecraftClass(serverVersion, "PacketPlayOutChat");
            Constructor<?> chatPacketConstructor = chatPacketClass.getConstructor(baseComponentClass);
            Class<?> titlePacketClass = CraftBukkitAdapter.optionalMinecraftClass(serverVersion, "PacketPlayOutTitle");
            if (titlePacketClass != null) {
                titlePacketClassAction = CraftBukkitAdapter.minecraftClass(serverVersion, "PacketPlayOutTitle$EnumTitleAction");
                titlePacketConstructor = titlePacketClass.getConstructor(titlePacketClassAction, baseComponentClass);
            } else {
                titlePacketClassAction = null;
                titlePacketConstructor = null;
            }
            Class chatSerializerClass = Arrays.stream(baseComponentClass.getClasses()).filter(JsonDeserializer.class::isAssignableFrom).findAny().orElseGet(() -> {
                try {
                    return CraftBukkitAdapter.minecraftClass(serverVersion, "ChatSerializer");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
            Method serializeMethod = Arrays.stream(chatSerializerClass.getMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.getReturnType().equals(baseComponentClass)).filter(m -> m.getParameterCount() == 1 && m.getParameterTypes()[0].equals(String.class)).min(Comparator.comparing(Method::getName)).orElseThrow(() -> new RuntimeException("Unable to find serialize method"));
            return new AliveBinding(getHandleMethod, playerConnectionField, sendPacketMethod, chatPacketConstructor, titlePacketClassAction, titlePacketConstructor, serializeMethod);
        }
        catch (Throwable e) {
            return new DeadBinding();
        }
    }

    private static boolean isCompatibleServer(Class<?> serverClass) {
        return serverClass.getPackage().getName().startsWith("org.bukkit.craftbukkit") && serverClass.getSimpleName().equals("CraftServer");
    }

    private static Class<?> craftBukkitClass(String version, String name) throws ClassNotFoundException {
        return Class.forName("org.bukkit.craftbukkit." + version + name);
    }

    private static Class<?> minecraftClass(String version, String name) throws ClassNotFoundException {
        return Class.forName("net.minecraft.server." + version + name);
    }

    private static String maybeVersion(String version) {
        if (version.isEmpty()) {
            return "";
        }
        if (version.charAt(0) == '.') {
            return version.substring(1) + '.';
        }
        throw new IllegalArgumentException("Unknown version " + version);
    }

    private static Class<?> optionalMinecraftClass(String version, String name) {
        try {
            return CraftBukkitAdapter.minecraftClass(version, name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public void sendComponent(List<? extends CommandSender> viewers, Component component, boolean actionBar) {
        if (!REFLECTION_BINDINGS.valid()) {
            return;
        }
        Object packet = null;
        Iterator<? extends CommandSender> iterator = viewers.iterator();
        while (iterator.hasNext()) {
            CommandSender sender = iterator.next();
            if (!(sender instanceof Player)) continue;
            try {
                Player player = (Player)sender;
                if (packet == null) {
                    packet = REFLECTION_BINDINGS.createPacket(component, actionBar);
                }
                REFLECTION_BINDINGS.sendPacket(packet, player);
                iterator.remove();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static final class AliveBinding
    extends Binding {
        private final Method getHandleMethod;
        private final Field playerConnectionField;
        private final Method sendPacketMethod;
        private final Constructor<?> chatPacketConstructor;
        private final Class<? extends Enum> titlePacketClassAction;
        private final Constructor<?> titlePacketConstructor;
        private final boolean canMakeTitle;
        private final Method serializeMethod;

        AliveBinding(Method getHandleMethod, Field playerConnectionField, Method sendPacketMethod, Constructor<?> chatPacketConstructor, Class<? extends Enum> titlePacketClassAction, Constructor<?> titlePacketConstructor, Method serializeMethod) {
            this.getHandleMethod = getHandleMethod;
            this.playerConnectionField = playerConnectionField;
            this.sendPacketMethod = sendPacketMethod;
            this.chatPacketConstructor = chatPacketConstructor;
            this.titlePacketClassAction = titlePacketClassAction;
            this.titlePacketConstructor = titlePacketConstructor;
            this.canMakeTitle = this.titlePacketClassAction != null && this.titlePacketConstructor != null;
            this.serializeMethod = serializeMethod;
        }

        @Override
        boolean valid() {
            return true;
        }

        @Override
        Object createPacket(Component component, boolean actionBar) {
            String json = GsonComponentSerializer.INSTANCE.serialize(component);
            try {
                if (actionBar && this.canMakeTitle) {
                    Enum constant;
                    try {
                        constant = Enum.valueOf(this.titlePacketClassAction, "ACTIONBAR");
                    }
                    catch (IllegalArgumentException e) {
                        constant = this.titlePacketClassAction.getEnumConstants()[2];
                    }
                    return this.titlePacketConstructor.newInstance(constant, this.serializeMethod.invoke(null, json));
                }
                return this.chatPacketConstructor.newInstance(this.serializeMethod.invoke(null, json));
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("An exception was encountered while creating a packet for a component", e);
            }
        }

        @Override
        void sendPacket(Object packet, Player player) {
            try {
                Object connection = this.playerConnectionField.get(this.getHandleMethod.invoke((Object)player, new Object[0]));
                this.sendPacketMethod.invoke(connection, packet);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("An exception was encountered while sending a packet for a component", e);
            }
        }
    }

    private static final class DeadBinding
    extends Binding {
        private DeadBinding() {
        }

        @Override
        boolean valid() {
            return false;
        }

        @Override
        Object createPacket(Component component, boolean actionBar) {
            throw new UnsupportedOperationException();
        }

        @Override
        void sendPacket(Object packet, Player player) {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class Binding {
        private Binding() {
        }

        abstract boolean valid();

        abstract Object createPacket(Component var1, boolean var2);

        abstract void sendPacket(Object var1, Player var2);
    }
}

