/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.IDataWatcher;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InMemoryDataWatcher
implements IDataWatcher {
    private Object entityHandle;
    private Map<Integer, WrappedWatchableObject> entries = new HashMap<Integer, WrappedWatchableObject>();
    private static FieldAccessor ENTITY_WATCHER_FIELD;
    private static FieldAccessor WATCHER_ENTITY_FIELD;
    private static FieldAccessor ARRAY_FIELD;
    private static ConstructorAccessor CONSTRUCTOR;
    private static boolean ARRAY_BACKED;
    private static Class<?> SYNCED_DATA_HOLDER_CLASS;

    public InMemoryDataWatcher() {
    }

    public InMemoryDataWatcher(Object handle) {
        this.entityHandle = InMemoryDataWatcher.entityFromWatcherHandle(handle);
        this.populateFromHandle(handle);
    }

    public InMemoryDataWatcher(Entity entity) {
        this.entityHandle = BukkitUnwrapper.getInstance().unwrapItem(entity);
        this.populateFromEntity(entity);
    }

    public InMemoryDataWatcher(List<WrappedWatchableObject> objects) {
        for (WrappedWatchableObject obj : objects) {
            this.entries.put(obj.getIndex(), obj);
        }
    }

    public static WrappedDataWatcher getEntityWatcher(Entity entity) {
        return new WrappedDataWatcher(entity);
    }

    private static Object entityFromWatcherHandle(Object handle) {
        if (WATCHER_ENTITY_FIELD == null) {
            WATCHER_ENTITY_FIELD = Accessors.getFieldAccessor(MinecraftReflection.getDataWatcherClass(), SYNCED_DATA_HOLDER_CLASS, true);
        }
        return WATCHER_ENTITY_FIELD.get(handle);
    }

    public void populateFromEntity(Entity entity) {
        this.populateFromEntity(BukkitUnwrapper.getInstance().unwrapItem(entity));
    }

    public void applyToEntity(Entity entity) {
        this.applyToEntity(BukkitUnwrapper.getInstance().unwrapItem(entity));
    }

    private void applyToEntity(Object entityHandle) {
        if (ENTITY_WATCHER_FIELD == null) {
            ENTITY_WATCHER_FIELD = Accessors.getFieldAccessor(MinecraftReflection.getEntityClass(), MinecraftReflection.getDataWatcherClass(), true);
        }
        Object handle = this.getHandle(entityHandle);
        ENTITY_WATCHER_FIELD.set(entityHandle, handle);
    }

    private void populateFromHandle(Object handle) {
        Object[] backing;
        if (ARRAY_FIELD == null) {
            try {
                FuzzyReflection fuzzy = FuzzyReflection.fromClass(handle.getClass(), true);
                ARRAY_FIELD = Accessors.getFieldAccessor(fuzzy.getField(FuzzyFieldContract.newBuilder().banModifier(8).typeDerivedOf(Object[].class).build()));
            }
            catch (IllegalArgumentException ex) {
                throw new FieldAccessException("Failed to find watchable object array", ex);
            }
        }
        for (Object itemHandle : backing = (Object[])ARRAY_FIELD.get(handle)) {
            if (itemHandle == null) continue;
            WrappedWatchableObject object = new WrappedWatchableObject(itemHandle);
            this.entries.put(object.getIndex(), object);
        }
    }

    private void populateFromEntity(Object entityHandle) {
        if (ENTITY_WATCHER_FIELD == null) {
            ENTITY_WATCHER_FIELD = Accessors.getFieldAccessor(MinecraftReflection.getEntityClass(), MinecraftReflection.getDataWatcherClass(), true);
        }
        Object handle = ENTITY_WATCHER_FIELD.get(entityHandle);
        this.populateFromHandle(handle);
    }

    @Override
    public Object getHandle() {
        return this.getHandle(this.entityHandle);
    }

    public Object getHandle(Object entityHandle) {
        if (CONSTRUCTOR == null) {
            CONSTRUCTOR = Accessors.getConstructorAccessor(MinecraftReflection.getDataWatcherClass(), SYNCED_DATA_HOLDER_CLASS, MinecraftReflection.getArrayClass(MinecraftReflection.getDataWatcherItemClass()));
        }
        if (CONSTRUCTOR == null) {
            throw new IllegalStateException("Cannot find constructor for DataWatcher.");
        }
        Object[] items = new Object[this.entries.size()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = this.entries.get(i).getHandle();
        }
        return CONSTRUCTOR.invoke(null, entityHandle, items);
    }

    @Override
    public IDataWatcher deepClone() {
        InMemoryDataWatcher clone = new InMemoryDataWatcher();
        clone.entries = new HashMap<Integer, WrappedWatchableObject>(this.entries.size());
        clone.entityHandle = this.entityHandle;
        for (WrappedWatchableObject object : this) {
            clone.setObject(object.getWatcherObject(), object.getValue(), false);
        }
        return clone;
    }

    @Override
    @Deprecated
    @Nullable
    public Entity getEntity() {
        return this.entityHandle != null ? (Entity)MinecraftReflection.getBukkitEntity(this.entityHandle) : null;
    }

    @Override
    @Deprecated
    public void setEntity(Entity entity) {
        this.entityHandle = BukkitUnwrapper.getInstance().unwrapItem(entity);
    }

    @Override
    public Map<Integer, WrappedWatchableObject> asMap() {
        return ImmutableMap.copyOf(this.entries);
    }

    @Override
    public Set<Integer> getIndexes() {
        return this.entries.keySet();
    }

    @Override
    public List<WrappedWatchableObject> getWatchableObjects() {
        return Lists.newArrayList(this.entries.values());
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public WrappedWatchableObject getWatchableObject(int index) {
        return this.entries.get(index);
    }

    @Override
    public WrappedWatchableObject remove(int index) {
        return this.entries.remove(index);
    }

    @Override
    public boolean hasIndex(int index) {
        return this.entries.containsKey(index);
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public Object getObject(int index) {
        WrappedWatchableObject obj = this.getWatchableObject(index);
        return obj != null ? obj.getValue() : null;
    }

    @Override
    public Object getObject(WrappedDataWatcher.WrappedDataWatcherObject object) {
        return this.getObject(object.getIndex());
    }

    @Override
    public void setObject(WrappedDataWatcher.WrappedDataWatcherObject object, WrappedWatchableObject value, boolean update) {
        this.entries.put(object.getIndex(), value);
        if (update) {
            value.setDirtyState(true);
        }
    }

    @Override
    public void setObject(WrappedDataWatcher.WrappedDataWatcherObject object, Object value, boolean update) {
        this.setObject(object, new WrappedWatchableObject(object, value), update);
    }

    @Override
    @NotNull
    public Iterator<WrappedWatchableObject> iterator() {
        return this.entries.values().iterator();
    }

    static {
        ARRAY_BACKED = MinecraftVersion.v1_20_5.atOrAbove();
        SYNCED_DATA_HOLDER_CLASS = ARRAY_BACKED ? MinecraftReflection.getMinecraftClass("network.syncher.SyncedDataHolder") : MinecraftReflection.getEntityClass();
    }
}

