/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.utility.ClassSource;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

final class CachedPackage {
    private final String packageName;
    private final ClassSource source;
    private final Map<String, Optional<Class<?>>> cache;

    CachedPackage(String packageName, ClassSource source) {
        this.source = source;
        this.packageName = packageName;
        this.cache = new ConcurrentHashMap();
    }

    public static String combine(String packageName, String className) {
        if (packageName == null || packageName.isEmpty()) {
            return className;
        }
        return packageName + "." + className;
    }

    public void setPackageClass(String className, Class<?> clazz) {
        Optional<Class<?>> previous = this.cache.get(className);
        if (previous != null && previous.isPresent()) {
            throw new IllegalStateException("Tried to redefine class " + className);
        }
        this.cache.put(className, Optional.ofNullable(clazz));
    }

    public void removePackageClass(String className) {
        this.cache.remove(className);
    }

    private Optional<Class<?>> resolveClass(String className) {
        return this.source.loadClass(CachedPackage.combine(this.packageName, className));
    }

    public Optional<Class<?>> getPackageClass(String className, String ... aliases) {
        return this.cache.computeIfAbsent(className, x -> {
            Optional<Class<?>> clazz = this.resolveClass(className);
            if (clazz.isPresent()) {
                return clazz;
            }
            for (String alias : aliases) {
                clazz = this.resolveClass(alias);
                if (!clazz.isPresent()) continue;
                return clazz;
            }
            return Optional.empty();
        });
    }
}

