/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.timing;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.timing.PluginTimingTracker;
import com.comphenix.protocol.timing.StatisticsStream;
import com.comphenix.protocol.timing.TimingListenerType;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Map;
import java.util.TreeSet;

public class TimingReport {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String META_STARTED = "Started: %s" + NEWLINE;
    private static final String META_STOPPED = "Stopped: %s (after %s seconds)" + NEWLINE;
    private static final String PLUGIN_HEADER = "=== PLUGIN %s ===" + NEWLINE;
    private static final String LISTENER_HEADER = " TYPE: %s " + NEWLINE;
    private static final String SEPERATION_LINE = " " + Strings.repeat((String)"-", (int)139) + NEWLINE;
    private static final String STATISTICS_HEADER = " Protocol:      Name:                         Count:       Min (ms):       Max (ms):       Mean (ms):      Std (ms): " + NEWLINE;
    private static final String STATISTICS_ROW = " %-14s %-29s %-12d %-15.6f %-15.6f %-15.6f %.6f " + NEWLINE;
    private static final String SUM_MAIN_THREAD = " => Time on main thread: %.6f ms" + NEWLINE;
    private final Date startTime;
    private final Date stopTime;
    private final ImmutableMap<String, ImmutableMap<TimingListenerType, PluginTimingTracker>> trackerMap;

    public TimingReport(Date startTime, Date stopTime, ImmutableMap<String, ImmutableMap<TimingListenerType, PluginTimingTracker>> trackerMap) {
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.trackerMap = trackerMap;
    }

    public void saveTo(Path path) throws IOException {
        long seconds = Math.abs((this.stopTime.getTime() - this.startTime.getTime()) / 1000L);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(String.format(META_STARTED, this.startTime));
            writer.write(String.format(META_STOPPED, this.stopTime, seconds));
            writer.write(NEWLINE);
            for (Map.Entry pluginEntry : this.trackerMap.entrySet()) {
                writer.write(String.format(PLUGIN_HEADER, pluginEntry.getKey()));
                for (Map.Entry entry : ((ImmutableMap)pluginEntry.getValue()).entrySet()) {
                    TimingListenerType type = (TimingListenerType)((Object)entry.getKey());
                    PluginTimingTracker tracker = (PluginTimingTracker)entry.getValue();
                    if (!tracker.hasReceivedData()) continue;
                    writer.write(String.format(LISTENER_HEADER, new Object[]{type}));
                    writer.write(SEPERATION_LINE);
                    this.saveStatistics(writer, tracker, type);
                    writer.write(SEPERATION_LINE);
                }
                writer.write(NEWLINE);
            }
        }
    }

    private void saveStatistics(Writer destination, PluginTimingTracker tracker, TimingListenerType type) throws IOException {
        Map<PacketType, StatisticsStream> streams = tracker.getStatistics();
        StatisticsStream sum = new StatisticsStream();
        int count = 0;
        destination.write(STATISTICS_HEADER);
        destination.write(SEPERATION_LINE);
        for (PacketType key : new TreeSet<PacketType>(streams.keySet())) {
            StatisticsStream stream = streams.get(key);
            if (stream == null || stream.getCount() <= 0) continue;
            this.printStatistic(destination, key, stream);
            ++count;
            sum = sum.add(stream);
        }
        if (count > 1) {
            this.printStatistic(destination, null, sum);
        }
        if (type == TimingListenerType.SYNC_OUTBOUND) {
            destination.write(String.format(SUM_MAIN_THREAD, this.nanoToMillis((double)sum.getCount() * sum.getMean())));
        }
    }

    private void printStatistic(Writer destination, PacketType key, StatisticsStream stream) throws IOException {
        destination.write(String.format(STATISTICS_ROW, key != null ? key.getProtocol() : "SUM", key != null ? key.name() : "-", stream.getCount(), this.nanoToMillis(stream.getMinimum()), this.nanoToMillis(stream.getMaximum()), this.nanoToMillis(stream.getMean()), this.nanoToMillis(stream.getStandardDeviation())));
    }

    private double nanoToMillis(double value) {
        return value / 1000000.0;
    }
}

