/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.temporary;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.injector.netty.Injector;
import com.comphenix.protocol.injector.temporary.TemporaryPlayer;
import com.comphenix.protocol.utility.ByteBuddyFactory;
import com.comphenix.protocol.utility.ChatExtensions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TemporaryPlayerFactory {
    private static final Constructor<? extends Player> PLAYER_CONSTRUCTOR = TemporaryPlayerFactory.setupProxyPlayerConstructor();

    private TemporaryPlayerFactory() {
    }

    public static Injector getInjectorFromPlayer(Player player) {
        if (player instanceof TemporaryPlayer) {
            return ((TemporaryPlayer)player).getInjector();
        }
        return null;
    }

    public static void setInjectorForPlayer(Player player, Injector injector) {
        ((TemporaryPlayer)player).setInjector(injector);
    }

    private static Constructor<? extends Player> setupProxyPlayerConstructor() {
        MethodDelegation implementation = MethodDelegation.to((Object)new Object(){

            @RuntimeType
            public Object delegate(@This Object obj, @Origin Method method, @FieldValue(value="injector") Injector injector, Object ... args) throws Throwable {
                String methodName = method.getName();
                if (injector == null) {
                    throw new IllegalStateException("Unable to find injector.");
                }
                if (methodName.equals("getPlayer")) {
                    return injector.getPlayer();
                }
                if (methodName.equals("getAddress")) {
                    return injector.getAddress();
                }
                if (methodName.equals("getServer")) {
                    return Bukkit.getServer();
                }
                if (methodName.equals("chat") || methodName.equals("sendMessage")) {
                    try {
                        Object argument = args[0];
                        if (argument instanceof String) {
                            return TemporaryPlayerFactory.sendMessage(injector, (String)argument);
                        }
                        if (argument instanceof String[]) {
                            for (String message : (String[])argument) {
                                TemporaryPlayerFactory.sendMessage(injector, message);
                            }
                            return null;
                        }
                    }
                    catch (Exception exception) {
                        throw exception.getCause();
                    }
                }
                if (methodName.equals("kickPlayer")) {
                    injector.disconnect((String)args[0]);
                    return null;
                }
                Player updated = injector.getPlayer();
                if (updated != obj && updated != null) {
                    return method.invoke((Object)updated, args);
                }
                if (methodName.equals("isOnline")) {
                    return injector.isConnected();
                }
                if (methodName.equals("getName")) {
                    return "UNKNOWN[" + String.valueOf(injector.getAddress()) + "]";
                }
                throw new UnsupportedOperationException("The method " + method.getName() + " is not supported for temporary players.");
            }
        });
        ElementMatcher.Junction callbackFilter = ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class).or((ElementMatcher)ElementMatchers.isDeclaredBy(TemporaryPlayer.class)));
        try {
            Constructor constructor = ByteBuddyFactory.getInstance().createSubclass(TemporaryPlayer.class, ConstructorStrategy.Default.DEFAULT_CONSTRUCTOR).name(TemporaryPlayerFactory.class.getPackage().getName() + ".TemporaryPlayerInvocationHandler").implement(new Type[]{Player.class}).method((ElementMatcher)callbackFilter).intercept((Implementation)implementation).make().load(ByteBuddyFactory.getInstance().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find Temporary Player constructor!", e);
        }
    }

    private static Object sendMessage(Injector injector, String message) {
        for (PacketContainer packet : ChatExtensions.createChatPackets(message)) {
            injector.sendClientboundPacket(packet.getHandle(), null, false);
        }
        return null;
    }

    public static Player createTemporaryPlayer() {
        try {
            return PLAYER_CONSTRUCTOR.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException exception) {
            throw new IllegalStateException("Unable to create temporary player", exception);
        }
    }
}

