/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;

class PluginVerifier {
    private static final Set<String> DYNAMIC_DEPENDENCY = ImmutableSet.of((Object)"mcore", (Object)"MassiveCore");
    private final Set<String> loadedAfter = new HashSet<String>();
    private final Plugin dependency;

    public PluginVerifier(Plugin dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException("dependency cannot be NULL.");
        }
        try {
            if (this.safeConversion(dependency.getDescription().getLoadBefore()).size() > 0) {
                throw new IllegalArgumentException("dependency cannot have a load directives.");
            }
        }
        catch (LinkageError e) {
            dependency.getLogger().log(Level.WARNING, "Failed to determine loadBefore: " + String.valueOf(e));
        }
        this.dependency = dependency;
    }

    private Plugin getPlugin(String pluginName) {
        Plugin plugin = this.getPluginOrDefault(pluginName);
        if (plugin != null) {
            return plugin;
        }
        throw new PluginNotFoundException("Cannot find plugin " + pluginName);
    }

    private Plugin getPluginOrDefault(String pluginName) {
        return this.dependency.getServer().getPluginManager().getPlugin(pluginName);
    }

    public VerificationResult verify(String pluginName) {
        if (pluginName == null) {
            throw new IllegalArgumentException("pluginName cannot be NULL.");
        }
        return this.verify(this.getPlugin(pluginName));
    }

    public VerificationResult verify(Plugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("plugin cannot be NULL.");
        }
        String name = plugin.getName();
        if (!(this.dependency.equals((Object)plugin) || this.loadedAfter.contains(name) || DYNAMIC_DEPENDENCY.contains(name))) {
            if (this.verifyLoadOrder(this.dependency, plugin)) {
                this.loadedAfter.add(plugin.getName());
            } else {
                return VerificationResult.NO_DEPEND;
            }
        }
        return VerificationResult.VALID;
    }

    private boolean verifyLoadOrder(Plugin beforePlugin, Plugin afterPlugin) {
        if (this.hasDependency(afterPlugin, beforePlugin)) {
            return true;
        }
        return beforePlugin.getDescription().getLoad() == PluginLoadOrder.STARTUP && afterPlugin.getDescription().getLoad() == PluginLoadOrder.POSTWORLD;
    }

    private boolean hasDependency(Plugin plugin, Plugin dependency) {
        return this.hasDependency(plugin, dependency, Sets.newHashSet());
    }

    private Set<String> safeConversion(List<String> list) {
        if (list == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(list);
    }

    private boolean hasDependency(Plugin plugin, Plugin dependency, Set<String> checking) {
        Sets.SetView childNames = Sets.union(this.safeConversion(plugin.getDescription().getDepend()), this.safeConversion(plugin.getDescription().getSoftDepend()));
        if (!checking.add(plugin.getName())) {
            throw new IllegalStateException("Cycle detected in dependency graph: " + String.valueOf(plugin));
        }
        if (childNames.contains(dependency.getName())) {
            return true;
        }
        for (String childName : childNames) {
            Plugin childPlugin = this.getPluginOrDefault(childName);
            if (childPlugin == null || !this.hasDependency(childPlugin, dependency, checking)) continue;
            return true;
        }
        checking.remove(plugin.getName());
        return false;
    }

    public static class PluginNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 8956699101336877611L;

        public PluginNotFoundException() {
        }

        public PluginNotFoundException(String message) {
            super(message);
        }
    }

    public static enum VerificationResult {
        VALID,
        NO_DEPEND;


        public boolean isValid() {
            return this == VALID;
        }
    }
}

