/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.caching;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.caching.MetaContexts;
import me.lucko.luckperms.api.caching.MetaData;
import me.lucko.luckperms.api.caching.PermissionData;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface CachedData {
    public @NonNull PermissionData getPermissionData(@NonNull Contexts var1);

    public @NonNull MetaData getMetaData(@NonNull MetaContexts var1);

    public @NonNull MetaData getMetaData(@NonNull Contexts var1);

    public @NonNull PermissionData calculatePermissions(@NonNull Contexts var1);

    public @NonNull MetaData calculateMeta(@NonNull MetaContexts var1);

    public @NonNull MetaData calculateMeta(@NonNull Contexts var1);

    public void recalculatePermissions(@NonNull Contexts var1);

    public void recalculateMeta(@NonNull MetaContexts var1);

    public void recalculateMeta(@NonNull Contexts var1);

    public @NonNull CompletableFuture<? extends PermissionData> reloadPermissions(@NonNull Contexts var1);

    public @NonNull CompletableFuture<? extends MetaData> reloadMeta(@NonNull MetaContexts var1);

    public @NonNull CompletableFuture<? extends MetaData> reloadMeta(@NonNull Contexts var1);

    public void recalculatePermissions();

    public void recalculateMeta();

    public @NonNull CompletableFuture<Void> reloadPermissions();

    public @NonNull CompletableFuture<Void> reloadMeta();

    default public void preCalculate(@NonNull Set<Contexts> contexts) {
        contexts.forEach(this::preCalculate);
    }

    default public void preCalculate(@NonNull Contexts contexts) {
        Objects.requireNonNull(contexts, "contexts");
        this.getPermissionData(contexts);
        this.getMetaData(contexts);
    }

    public void invalidatePermissions(@NonNull Contexts var1);

    public void invalidateMeta(@NonNull MetaContexts var1);

    public void invalidateMeta(@NonNull Contexts var1);

    public void invalidatePermissions();

    public void invalidateMeta();

    public void invalidatePermissionCalculators();
}

