/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.api.ActionLogger;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.Group;
import me.lucko.luckperms.api.LPConfiguration;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.api.MessagingService;
import me.lucko.luckperms.api.NodeFactory;
import me.lucko.luckperms.api.Storage;
import me.lucko.luckperms.api.Track;
import me.lucko.luckperms.api.User;
import me.lucko.luckperms.api.UuidCache;
import me.lucko.luckperms.api.context.ContextCalculator;
import me.lucko.luckperms.api.context.ContextManager;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.event.EventBus;
import me.lucko.luckperms.api.manager.GroupManager;
import me.lucko.luckperms.api.manager.TrackManager;
import me.lucko.luckperms.api.manager.UserManager;
import me.lucko.luckperms.api.messenger.MessengerProvider;
import me.lucko.luckperms.api.metastacking.MetaStackFactory;
import me.lucko.luckperms.api.platform.PlatformInfo;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface LuckPermsApi {
    public @NonNull PlatformInfo getPlatformInfo();

    public @NonNull UserManager getUserManager();

    public @NonNull GroupManager getGroupManager();

    public @NonNull TrackManager getTrackManager();

    public @NonNull CompletableFuture<Void> runUpdateTask();

    public @NonNull EventBus getEventBus();

    public @NonNull LPConfiguration getConfiguration();

    public @NonNull Storage getStorage();

    public @NonNull Optional<MessagingService> getMessagingService();

    public void registerMessengerProvider(@NonNull MessengerProvider var1);

    public @NonNull ActionLogger getActionLogger();

    @Deprecated
    public @NonNull UuidCache getUuidCache();

    public @NonNull ContextManager getContextManager();

    public @NonNull NodeFactory getNodeFactory();

    public @NonNull MetaStackFactory getMetaStackFactory();

    default public @Nullable User getUser(@NonNull UUID uuid) {
        return this.getUserManager().getUser(uuid);
    }

    default public @NonNull Optional<User> getUserSafe(@NonNull UUID uuid) {
        return this.getUserManager().getUserOpt(uuid);
    }

    default public @Nullable User getUser(@NonNull String name) {
        return this.getUserManager().getUser(name);
    }

    default public @NonNull Optional<User> getUserSafe(@NonNull String name) {
        return this.getUserManager().getUserOpt(name);
    }

    default public @NonNull Set<User> getUsers() {
        return this.getUserManager().getLoadedUsers();
    }

    default public boolean isUserLoaded(@NonNull UUID uuid) {
        return this.getUserManager().isLoaded(uuid);
    }

    default public void cleanupUser(@NonNull User user) {
        this.getUserManager().cleanupUser(user);
    }

    default public @Nullable Group getGroup(@NonNull String name) {
        return this.getGroupManager().getGroup(name);
    }

    default public @NonNull Optional<Group> getGroupSafe(@NonNull String name) {
        return this.getGroupManager().getGroupOpt(name);
    }

    default public @NonNull Set<Group> getGroups() {
        return this.getGroupManager().getLoadedGroups();
    }

    default public boolean isGroupLoaded(@NonNull String name) {
        return this.getGroupManager().isLoaded(name);
    }

    default public @Nullable Track getTrack(@NonNull String name) {
        return this.getTrackManager().getTrack(name);
    }

    default public @NonNull Optional<Track> getTrackSafe(@NonNull String name) {
        return this.getTrackManager().getTrackOpt(name);
    }

    default public @NonNull Set<Track> getTracks() {
        return this.getTrackManager().getLoadedTracks();
    }

    default public boolean isTrackLoaded(@NonNull String name) {
        return this.getTrackManager().isLoaded(name);
    }

    default public @NonNull LogEntry.Builder newLogEntryBuilder() {
        return this.getActionLogger().newEntryBuilder();
    }

    default public  @NonNull Node.Builder buildNode(@NonNull String permission) throws IllegalArgumentException {
        return this.getNodeFactory().newBuilder(permission);
    }

    default public void registerContextCalculator(@NonNull ContextCalculator<?> calculator) {
        this.getContextManager().registerCalculator(calculator);
    }

    default public @NonNull Optional<Contexts> getContextForUser(@NonNull User user) {
        return this.getContextManager().lookupApplicableContexts(user);
    }

    default public @NonNull ContextSet getContextForPlayer(@NonNull Object player) {
        return this.getContextManager().getApplicableContext(player);
    }

    default public @NonNull Contexts getContextsForPlayer(@NonNull Object player) {
        return this.getContextManager().getApplicableContexts(player);
    }
}

