/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import me.lucko.luckperms.api.context.AbstractContextSet;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;

@Immutable
public final class ImmutableContextSet
extends AbstractContextSet
implements ContextSet {
    private static final ImmutableContextSet EMPTY = new ImmutableContextSet((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.of());
    private final ImmutableSetMultimap<String, String> map;
    private final int hashCode;

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static ImmutableContextSet singleton(@Nonnull String key, @Nonnull String value) {
        return new ImmutableContextSet((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.of((Object)ImmutableContextSet.sanitizeKey(key), (Object)ImmutableContextSet.sanitizeValue(value)));
    }

    @Nonnull
    public static ImmutableContextSet of(@Nonnull String key1, @Nonnull String value1, @Nonnull String key2, @Nonnull String value2) {
        return new ImmutableContextSet((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.of((Object)ImmutableContextSet.sanitizeKey(key1), (Object)ImmutableContextSet.sanitizeValue(value1), (Object)ImmutableContextSet.sanitizeKey(key2), (Object)ImmutableContextSet.sanitizeValue(value2)));
    }

    @Nonnull
    public static ImmutableContextSet fromEntries(@Nonnull Iterable<? extends Map.Entry<String, String>> iterable) {
        Objects.requireNonNull(iterable, "iterable");
        Builder builder = ImmutableContextSet.builder();
        for (Map.Entry<String, String> entry : iterable) {
            builder.add(entry);
        }
        return builder.build();
    }

    @Nonnull
    public static ImmutableContextSet fromMap(@Nonnull Map<String, String> map) {
        return ImmutableContextSet.fromEntries(Objects.requireNonNull(map, "map").entrySet());
    }

    @Nonnull
    public static ImmutableContextSet fromMultimap(@Nonnull Multimap<String, String> multimap) {
        return ImmutableContextSet.fromEntries(Objects.requireNonNull(multimap, "multimap").entries());
    }

    @Nonnull
    public static ImmutableContextSet fromSet(@Nonnull ContextSet contextSet) {
        return Objects.requireNonNull(contextSet, "contextSet").makeImmutable();
    }

    @Nonnull
    public static ImmutableContextSet empty() {
        return EMPTY;
    }

    ImmutableContextSet(ImmutableSetMultimap<String, String> contexts) {
        this.map = contexts;
        this.hashCode = this.map.hashCode();
    }

    @Override
    protected SetMultimap<String, String> backing() {
        return this.map;
    }

    @Override
    protected void copyTo(SetMultimap<String, String> other) {
        other.putAll(this.map);
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    @Nonnull
    @Deprecated
    public ImmutableContextSet makeImmutable() {
        return this;
    }

    @Override
    @Nonnull
    public MutableContextSet mutableCopy() {
        return MutableContextSet.fromSet(this);
    }

    @Override
    @Nonnull
    public Set<Map.Entry<String, String>> toSet() {
        return this.map.entries();
    }

    @Override
    @Nonnull
    @Deprecated
    public Map<String, String> toMap() {
        ImmutableMap.Builder m = ImmutableMap.builder();
        for (Map.Entry e : this.map.entries()) {
            m.put(e.getKey(), e.getValue());
        }
        return m.build();
    }

    @Override
    @Nonnull
    public Multimap<String, String> toMultimap() {
        return this.map;
    }

    @Override
    @Nonnull
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.map.entries().iterator();
    }

    @Override
    public Spliterator<Map.Entry<String, String>> spliterator() {
        return this.map.entries().spliterator();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ImmutableContextSet(contexts=" + this.map + ")";
    }

    public static final class Builder {
        private ImmutableSetMultimap.Builder<String, String> builder;

        private Builder() {
        }

        private synchronized ImmutableSetMultimap.Builder<String, String> builder() {
            if (this.builder == null) {
                this.builder = ImmutableSetMultimap.builder();
            }
            return this.builder;
        }

        private void put(String key, String value) {
            this.builder().put((Object)key, (Object)value);
        }

        @Nonnull
        public Builder add(@Nonnull String key, @Nonnull String value) {
            this.put(AbstractContextSet.sanitizeKey(key), AbstractContextSet.sanitizeValue(value));
            return this;
        }

        @Nonnull
        public Builder add(@Nonnull Map.Entry<String, String> entry) {
            Objects.requireNonNull(entry, "entry");
            this.add(entry.getKey(), entry.getValue());
            return this;
        }

        @Nonnull
        public Builder addAll(@Nonnull Iterable<? extends Map.Entry<String, String>> iterable) {
            for (Map.Entry<String, String> entry : Objects.requireNonNull(iterable, "iterable")) {
                this.add(entry);
            }
            return this;
        }

        @Nonnull
        public Builder addAll(@Nonnull Map<String, String> map) {
            this.addAll(Objects.requireNonNull(map, "map").entrySet());
            return this;
        }

        @Nonnull
        public Builder addAll(@Nonnull Multimap<String, String> multimap) {
            this.addAll(Objects.requireNonNull(multimap, "multimap").entries());
            return this;
        }

        @Nonnull
        public Builder addAll(@Nonnull ContextSet contextSet) {
            Objects.requireNonNull(contextSet, "contextSet");
            if (contextSet instanceof AbstractContextSet) {
                AbstractContextSet other = (AbstractContextSet)contextSet;
                if (!other.isEmpty()) {
                    this.builder().putAll(other.backing());
                }
            } else {
                this.addAll(contextSet.toMultimap());
            }
            return this;
        }

        @Nonnull
        public ImmutableContextSet build() {
            if (this.builder == null) {
                return ImmutableContextSet.empty();
            }
            return new ImmutableContextSet((ImmutableSetMultimap<String, String>)this.builder.build());
        }
    }
}

