/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;

public final class ImmutableContextSet
implements ContextSet {
    private static final ImmutableContextSet EMPTY = new ImmutableContextSet((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.of());
    private final ImmutableSetMultimap<String, String> map;

    @Nonnull
    public static ImmutableContextSet singleton(@Nonnull String key, @Nonnull String value) {
        return new ImmutableContextSet((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.of((Object)((String)Preconditions.checkNotNull((Object)key, (Object)"key")).toLowerCase().intern(), (Object)((String)Preconditions.checkNotNull((Object)value, (Object)"value")).intern()));
    }

    @Nonnull
    public static ImmutableContextSet of(@Nonnull String key1, @Nonnull String value1, @Nonnull String key2, @Nonnull String value2) {
        return new ImmutableContextSet((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.of((Object)((String)Preconditions.checkNotNull((Object)key1, (Object)"key1")).toLowerCase().intern(), (Object)((String)Preconditions.checkNotNull((Object)value1, (Object)"value1")).intern(), (Object)((String)Preconditions.checkNotNull((Object)key2, (Object)"key2")).toLowerCase().intern(), (Object)((String)Preconditions.checkNotNull((Object)value2, (Object)"value2")).intern()));
    }

    @Nonnull
    public static ImmutableContextSet fromEntries(@Nonnull Iterable<? extends Map.Entry<String, String>> iterable) {
        Preconditions.checkNotNull(iterable, (Object)"iterable");
        ImmutableSetMultimap.Builder b = ImmutableSetMultimap.builder();
        for (Map.Entry<String, String> entry : iterable) {
            b.put((Object)((String)Preconditions.checkNotNull((Object)entry.getKey())).toLowerCase().intern(), (Object)((String)Preconditions.checkNotNull((Object)entry.getValue())).intern());
        }
        return new ImmutableContextSet((ImmutableSetMultimap<String, String>)b.build());
    }

    @Nonnull
    public static ImmutableContextSet fromMap(@Nonnull Map<String, String> map) {
        return ImmutableContextSet.fromEntries(((Map)Preconditions.checkNotNull(map, (Object)"map")).entrySet());
    }

    @Nonnull
    public static ImmutableContextSet fromMultimap(@Nonnull Multimap<String, String> multimap) {
        return ImmutableContextSet.fromEntries(((Multimap)Preconditions.checkNotNull(multimap, (Object)"multimap")).entries());
    }

    @Nonnull
    public static ImmutableContextSet fromSet(@Nonnull ContextSet contextSet) {
        return ((ContextSet)Preconditions.checkNotNull((Object)contextSet, (Object)"contextSet")).makeImmutable();
    }

    @Nonnull
    public static ImmutableContextSet empty() {
        return EMPTY;
    }

    ImmutableContextSet(ImmutableSetMultimap<String, String> contexts) {
        this.map = contexts;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    @Deprecated
    @Nonnull
    public ImmutableContextSet makeImmutable() {
        return this;
    }

    @Override
    @Nonnull
    public MutableContextSet mutableCopy() {
        return MutableContextSet.fromSet(this);
    }

    @Override
    @Nonnull
    public Set<Map.Entry<String, String>> toSet() {
        return this.map.entries();
    }

    @Override
    @Nonnull
    public Map<String, String> toMap() {
        ImmutableMap.Builder m = ImmutableMap.builder();
        for (Map.Entry e : this.map.entries()) {
            m.put(e.getKey(), e.getValue());
        }
        return m.build();
    }

    @Override
    @Nonnull
    public Multimap<String, String> toMultimap() {
        return this.map;
    }

    @Override
    @Nonnull
    public boolean containsKey(@Nonnull String key) {
        return this.map.containsKey((Object)((String)Preconditions.checkNotNull((Object)key, (Object)"key")).toLowerCase().intern());
    }

    @Override
    @Nonnull
    public Set<String> getValues(@Nonnull String key) {
        ImmutableSet values = this.map.get((Object)((String)Preconditions.checkNotNull((Object)key, (Object)"key")).toLowerCase().intern());
        return values != null ? ImmutableSet.copyOf((Collection)values) : ImmutableSet.of();
    }

    @Override
    @Nonnull
    public boolean has(@Nonnull String key, @Nonnull String value) {
        return this.map.containsEntry((Object)((String)Preconditions.checkNotNull((Object)key, (Object)"key")).toLowerCase().intern(), (Object)((String)Preconditions.checkNotNull((Object)value, (Object)"value")).intern());
    }

    @Override
    @Nonnull
    public boolean hasIgnoreCase(@Nonnull String key, @Nonnull String value) {
        value = ((String)Preconditions.checkNotNull((Object)value, (Object)"value")).intern();
        ImmutableSet values = this.map.get((Object)((String)Preconditions.checkNotNull((Object)key, (Object)"key")).toLowerCase().intern());
        if (values == null || values.isEmpty()) {
            return false;
        }
        for (String val : values) {
            if (!val.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        ContextSet other = (ContextSet)o;
        if (other instanceof MutableContextSet) {
            return other.equals(this);
        }
        Multimap<String, String> thisContexts = this.toMultimap();
        Multimap<String, String> otherContexts = other.toMultimap();
        return thisContexts.equals(otherContexts);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return "ImmutableContextSet(contexts=" + this.map + ")";
    }
}

