//[okio](../../../index.md)/[okio](../index.md)/[GzipSink](index.md)

# GzipSink

[jvm]\
class [GzipSink](index.md)(sink: [Sink](../-sink/index.md)) : [Sink](../-sink/index.md)

A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink.

###  Sync flush

Aggressive flushing of this stream may result in reduced compression. Each call to [flush](flush.md) immediately compresses all currently-buffered data; this early compression may be less effective than compression performed without flushing.

This is equivalent to using [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) with the sync flush option. This class does not offer any partial flush mechanism. For best performance, only call [flush](flush.md) when application behavior requires it.

## Constructors

| | |
|---|---|
| [GzipSink](-gzip-sink.md) | [jvm]<br>constructor(sink: [Sink](../-sink/index.md)) |

## Properties

| Name | Summary |
|---|---|
| [deflater](deflater.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;deflater&quot;)<br>val [deflater](deflater.md): [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)<br>The deflater used to compress the body. |

## Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md) | [common]<br>fun [Sink](../-sink/index.md).[buffer](../buffer.md)(): [BufferedSink](../-buffered-sink/index.md)<br>Returns a new sink that buffers writes to `sink`. The returned sink will batch writes to `sink`. Use this wherever you write to a sink to get an ergonomic and efficient access to data. |
| [cipherSink](../cipher-sink.md) | [jvm]<br>fun [Sink](../-sink/index.md).[cipherSink](../cipher-sink.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSink](../-cipher-sink/index.md)<br>Returns a sink that uses [cipher](../cipher-sink.md) to encrypt or decrypt this. |
| [close](close.md) | [jvm]<br>open override fun [close](close.md)() |
| [deflate](../deflate.md) | [jvm]<br>inline fun [Sink](../-sink/index.md).[deflate](../deflate.md)(deflater: [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) = Deflater()): [DeflaterSink](../-deflater-sink/index.md)<br>Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md) while writing. |
| [flush](flush.md) | [jvm]<br>open override fun [flush](flush.md)() |
| [gzip](../gzip.md) | [jvm]<br>inline fun [Sink](../-sink/index.md).[gzip](../gzip.md)(): [GzipSink](index.md)<br>Returns a [GzipSink](index.md) that gzip-compresses to this [Sink](../-sink/index.md) while writing. |
| [hashingSink](../hashing-sink.md) | [jvm]<br>fun [Sink](../-sink/index.md).[hashingSink](../hashing-sink.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSink](../-hashing-sink/index.md)<br>Returns a sink that uses [digest](../hashing-sink.md) to hash this.<br>[jvm]<br>fun [Sink](../-sink/index.md).[hashingSink](../hashing-sink.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSink](../-hashing-sink/index.md)<br>Returns a sink that uses [mac](../hashing-sink.md) to hash this. |
| [timeout](timeout.md) | [jvm]<br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md) |
| [write](write.md) | [jvm]<br>open override fun [write](write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
