//[okio](../../../index.md)/[okio](../index.md)/[FileSystem](index.md)/[write](write.md)

# write

[common]\
expect inline fun &lt;[T](write.md)&gt; [write](write.md)(file: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, writerAction: [BufferedSink](../-buffered-sink/index.md).() -&gt; [T](write.md)): [T](write.md)

Creates a sink to write [file](write.md), executes [writerAction](write.md) to write it, and then closes the sink. This is a compact way to write a file.

#### Parameters

common

| | |
|---|---|
| mustCreate | true to throw an [IOException](../-i-o-exception/index.md) instead of overwriting an existing file.     This is equivalent to `O_EXCL` on POSIX and `CREATE_NEW` on Windows. |

[js, jvm, native, wasm]\
[js, native, wasm]\
actual inline fun &lt;[T](write.md)&gt; [write](write.md)(file: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), writerAction: [BufferedSink](../-buffered-sink/index.md).() -&gt; [T](write.md)): [T](write.md)

[jvm]\

@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;-write&quot;)

actual inline fun &lt;[T](write.md)&gt; [write](write.md)(file: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), writerAction: [BufferedSink](../-buffered-sink/index.md).() -&gt; [T](write.md)): [T](write.md)
