//[okio](../../../index.md)/[okio](../index.md)/[FileSystem](index.md)/[copy](copy.md)

# copy

[common]\
open fun [copy](copy.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))

Copies all the bytes from the file at [source](copy.md) to the file at [target](copy.md). This does not copy file metadata like last modified time, permissions, or extended attributes.

This function is not atomic; a failure may leave [target](copy.md) in an inconsistent state. For example, [target](copy.md) may be empty or contain only a prefix of [source](copy.md).

## Throws

| | |
|---|---|
| [okio.IOException](../-i-o-exception/index.md) | if [source](copy.md) cannot be read or if [target](copy.md) cannot be written. |

[js, jvm]\
[js]\
open fun [copy](copy.md)(source: Path, target: Path)

[jvm]\
open fun [copy](copy.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))

## Throws

| | |
|---|---|
| [okio.IOException](../-i-o-exception/index.md) | if [source](copy.md) cannot be read or if [target](copy.md) cannot be written. |
