/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.location;

import org.checkerframework.checker.nullness.qual.NonNull;

public interface World<T> {
    public static <T> NullWorld<T> nullWorld() {
        return new NullWorld();
    }

    public @NonNull T getPlatformWorld();

    public @NonNull String getName();

    public static class NullWorld<T>
    implements World<T> {
        private NullWorld() {
        }

        @Override
        public @NonNull T getPlatformWorld() {
            throw new UnsupportedOperationException("Cannot get platform world from NullWorld");
        }

        @Override
        public @NonNull String getName() {
            return "";
        }

        public boolean equals(Object obj) {
            return obj instanceof NullWorld;
        }

        public int hashCode() {
            return "null".hashCode();
        }
    }
}

