/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.Random;
import org.h2.message.DbException;

public class MathUtils {
    static SecureRandom cachedSecureRandom;
    static volatile boolean seeded;
    private static boolean usePrecisionWorkaround;
    private static final Random RANDOM;
    private static final int BIG_DECIMAL_SCALE_MAX = 100000;

    private MathUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized SecureRandom getSecureRandom() {
        block10: {
            if (cachedSecureRandom != null) {
                return cachedSecureRandom;
            }
            try {
                cachedSecureRandom = SecureRandom.getInstance("SHA1PRNG");
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                            byte[] byArray = secureRandom.generateSeed(20);
                            SecureRandom secureRandom2 = cachedSecureRandom;
                            synchronized (secureRandom2) {
                                cachedSecureRandom.setSeed(byArray);
                                seeded = true;
                            }
                        }
                        catch (Exception exception) {
                            MathUtils.warn("SecureRandom", exception);
                        }
                    }
                };
                try {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    thread.start();
                    Thread.yield();
                    try {
                        thread.join(400L);
                    }
                    catch (InterruptedException interruptedException) {
                        MathUtils.warn("InterruptedException", interruptedException);
                    }
                    if (seeded) break block10;
                    byte[] byArray = MathUtils.generateAlternativeSeed();
                    SecureRandom secureRandom = cachedSecureRandom;
                    synchronized (secureRandom) {
                        cachedSecureRandom.setSeed(byArray);
                    }
                }
                catch (SecurityException securityException) {
                    runnable.run();
                    MathUtils.generateAlternativeSeed();
                }
            }
            catch (Exception exception) {
                MathUtils.warn("SecureRandom", exception);
                cachedSecureRandom = new SecureRandom();
            }
        }
        return cachedSecureRandom;
    }

    private static byte[] generateAlternativeSeed() {
        try {
            Class<?> clazz;
            Object object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(System.currentTimeMillis());
            try {
                object = System.class.getMethod("nanoTime", new Class[0]);
                if (object != null) {
                    clazz = ((Method)object).invoke(null, new Object[0]);
                    dataOutputStream.writeUTF(((Object)clazz).toString());
                }
            }
            catch (Exception exception) {
                dataOutputStream.writeUTF(exception.toString());
            }
            dataOutputStream.writeInt(new Object().hashCode());
            object = Runtime.getRuntime();
            dataOutputStream.writeLong(((Runtime)object).freeMemory());
            dataOutputStream.writeLong(((Runtime)object).maxMemory());
            dataOutputStream.writeLong(((Runtime)object).totalMemory());
            try {
                dataOutputStream.writeUTF(System.getProperties().toString());
            }
            catch (Exception exception) {
                MathUtils.warn("generateAlternativeSeed", exception);
            }
            try {
                clazz = Class.forName("java.net.InetAddress");
                Object object2 = clazz.getMethod("getLocalHost", new Class[0]).invoke(null, new Object[0]);
                String string = clazz.getMethod("getHostName", new Class[0]).invoke(object2, new Object[0]).toString();
                dataOutputStream.writeUTF(string);
                Object[] objectArray = (Object[])clazz.getMethod("getAllByName", String.class).invoke(null, string);
                Method method = clazz.getMethod("getAddress", new Class[0]);
                for (Object object3 : objectArray) {
                    dataOutputStream.write((byte[])method.invoke(object3, new Object[0]));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (int i = 0; i < 16; ++i) {
                int n = 0;
                long l = System.currentTimeMillis();
                while (l == System.currentTimeMillis()) {
                    ++n;
                }
                dataOutputStream.writeInt(n);
            }
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            MathUtils.warn("generateAlternativeSeed", iOException);
            return new byte[1];
        }
    }

    static void warn(String string, Throwable throwable) {
        System.out.println("Warning: " + string);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public static int roundUpInt(int n, int n2) {
        return n + n2 - 1 & -n2;
    }

    public static long roundUpLong(long l, long l2) {
        return l + l2 - 1L & -l2;
    }

    public static void checkPowerOf2(int n) {
        if ((n & n - 1) != 0 && n > 0) {
            DbException.throwInternalError("not a power of 2: " + n);
        }
    }

    public static int nextPowerOf2(int n) {
        long l;
        for (l = 1L; l < (long)n && l < 0x3FFFFFFFL; l += l) {
        }
        return (int)l;
    }

    public static BigDecimal setScale(BigDecimal bigDecimal, int n) {
        if (n > 100000 || n < -100000) {
            throw DbException.getInvalidValueException("scale", n);
        }
        return bigDecimal.setScale(n, 4);
    }

    public static int convertLongToInt(long l) {
        if (l <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (l >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public static int reverseInt(int n) {
        n = (n & 0x55555555) << 1 | n >>> 1 & 0x55555555;
        n = (n & 0x33333333) << 2 | n >>> 2 & 0x33333333;
        n = (n & 0xF0F0F0F) << 4 | n >>> 4 & 0xF0F0F0F;
        n = n << 24 | (n & 0xFF00) << 8 | n >>> 8 & 0xFF00 | n >>> 24;
        return n;
    }

    public static long reverseLong(long l) {
        return (long)MathUtils.reverseInt((int)(l >>> 32)) & 0xFFFFFFFFL ^ (long)MathUtils.reverseInt((int)l) << 32;
    }

    public static int precision(BigDecimal bigDecimal) {
        if (!usePrecisionWorkaround) {
            try {
                return bigDecimal.precision();
            }
            catch (Throwable throwable) {
                usePrecisionWorkaround = true;
            }
        }
        return bigDecimal.unscaledValue().abs().toString().length();
    }

    public static int compareInt(int n, int n2) {
        return n == n2 ? 0 : (n < n2 ? -1 : 1);
    }

    public static int compareLong(long l, long l2) {
        return l == l2 ? 0 : (l < l2 ? -1 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long secureRandomLong() {
        SecureRandom secureRandom;
        SecureRandom secureRandom2 = secureRandom = MathUtils.getSecureRandom();
        synchronized (secureRandom2) {
            return secureRandom.nextLong();
        }
    }

    public static void randomBytes(byte[] byArray) {
        RANDOM.nextBytes(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] secureRandomBytes(int n) {
        SecureRandom secureRandom;
        if (n <= 0) {
            n = 1;
        }
        byte[] byArray = new byte[n];
        SecureRandom secureRandom2 = secureRandom = MathUtils.getSecureRandom();
        synchronized (secureRandom2) {
            secureRandom.nextBytes(byArray);
        }
        return byArray;
    }

    public static int randomInt(int n) {
        return RANDOM.nextInt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int secureRandomInt(int n) {
        SecureRandom secureRandom;
        SecureRandom secureRandom2 = secureRandom = MathUtils.getSecureRandom();
        synchronized (secureRandom2) {
            return secureRandom.nextInt(n);
        }
    }

    static {
        RANDOM = new Random();
    }
}

