/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.pool.TwitchModuleConnectionPool;
import com.github.twitch4j.common.util.CryptoUtils;
import com.github.twitch4j.pubsub.ITwitchPubSub;
import com.github.twitch4j.pubsub.PubSubSubscription;
import com.github.twitch4j.pubsub.TwitchPubSub;
import com.github.twitch4j.pubsub.TwitchPubSubBuilder;
import com.github.twitch4j.pubsub.domain.PubSubRequest;
import com.github.twitch4j.pubsub.events.PubSubListenResponseEvent;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class TwitchPubSubConnectionPool
extends TwitchModuleConnectionPool<TwitchPubSub, PubSubRequest, PubSubSubscription, Boolean, TwitchPubSubBuilder>
implements ITwitchPubSub {
    private final String threadPrefix = "twitch4j-pool-" + RandomStringUtils.random((int)4, (boolean)true, (boolean)true) + "-pubsub-";
    private final Cache<String, PubSubSubscription> subscriptionsByNonce = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();

    @Override
    public PubSubSubscription listenOnTopic(PubSubRequest request) {
        return this.subscribe(request);
    }

    @Override
    public boolean unsubscribeFromTopic(PubSubSubscription subscription) {
        return (Boolean)this.unsubscribe(subscription);
    }

    public PubSubSubscription subscribe(PubSubRequest pubSubRequest) {
        int topics = TwitchPubSubConnectionPool.getTopicCount(pubSubRequest);
        if (topics <= 0) {
            return null;
        }
        String nonce = TwitchPubSubConnectionPool.injectNonce(pubSubRequest);
        PubSubSubscription subscription = (PubSubSubscription)super.subscribe((Object)pubSubRequest);
        this.subscriptionsByNonce.put((Object)nonce, (Object)subscription);
        return subscription;
    }

    protected TwitchPubSub createConnection() {
        TwitchPubSub client = ((TwitchPubSubBuilder)this.advancedConfiguration.apply(TwitchPubSubBuilder.builder().withEventManager(this.getConnectionEventManager()).withScheduledThreadPoolExecutor(this.getExecutor(this.threadPrefix + RandomStringUtils.random((int)4, (boolean)true, (boolean)true), 1)).withProxyConfig((ProxyConfig)this.proxyConfig.get()))).build();
        client.getEventManager().onEvent("twitch4j-pubsub-pool-nonce-tracker", PubSubListenResponseEvent.class, e -> {
            if (StringUtils.isNotEmpty((CharSequence)e.getNonce())) {
                PubSubSubscription subscription = (PubSubSubscription)this.subscriptionsByNonce.asMap().remove(e.getNonce());
                if (e.hasError() && subscription != null) {
                    this.unsubscribe(subscription);
                }
            }
        });
        return client;
    }

    protected void disposeConnection(TwitchPubSub connection) {
        connection.close();
    }

    protected PubSubSubscription handleSubscription(TwitchPubSub twitchPubSub, PubSubRequest pubSubRequest) {
        return twitchPubSub != null ? twitchPubSub.listenOnTopic(pubSubRequest) : null;
    }

    protected PubSubSubscription handleDuplicateSubscription(TwitchPubSub twitchPubSub, TwitchPubSub old, PubSubRequest pubSubRequest) {
        PubSubSubscription subscription = new PubSubSubscription(pubSubRequest);
        return twitchPubSub != null && twitchPubSub != old && twitchPubSub.unsubscribeFromTopic(subscription) ? subscription : null;
    }

    protected Boolean handleUnsubscription(TwitchPubSub twitchPubSub, PubSubSubscription pubSubSubscription) {
        return twitchPubSub != null ? Boolean.valueOf(twitchPubSub.unsubscribeFromTopic(pubSubSubscription)) : null;
    }

    protected PubSubRequest getRequestFromSubscription(PubSubSubscription subscription) {
        return subscription.getRequest();
    }

    protected int getSubscriptionSize(PubSubRequest pubSubRequest) {
        return TwitchPubSubConnectionPool.getTopicCount(pubSubRequest);
    }

    private static String injectNonce(PubSubRequest req) {
        if (StringUtils.isBlank((CharSequence)req.getNonce())) {
            req.setNonce(CryptoUtils.generateNonce((int)30));
        }
        return req.getNonce();
    }

    private static int getTopicCount(PubSubRequest req) {
        Object topics = req.getData().get("topics");
        if (topics instanceof Collection) {
            return ((Collection)topics).size();
        }
        if (topics instanceof Iterable) {
            return (int)StreamSupport.stream(((Iterable)topics).spliterator(), false).count();
        }
        if (topics instanceof Object[]) {
            return ((Object[])topics).length;
        }
        return -1;
    }

    protected TwitchPubSubConnectionPool(TwitchPubSubConnectionPoolBuilder<?, ?> b) {
        super(b);
    }

    public static TwitchPubSubConnectionPoolBuilder<?, ?> builder() {
        return new TwitchPubSubConnectionPoolBuilderImpl();
    }

    private static final class TwitchPubSubConnectionPoolBuilderImpl
    extends TwitchPubSubConnectionPoolBuilder<TwitchPubSubConnectionPool, TwitchPubSubConnectionPoolBuilderImpl> {
        private TwitchPubSubConnectionPoolBuilderImpl() {
        }

        @Override
        protected TwitchPubSubConnectionPoolBuilderImpl self() {
            return this;
        }

        @Override
        public TwitchPubSubConnectionPool build() {
            return new TwitchPubSubConnectionPool(this);
        }
    }

    public static abstract class TwitchPubSubConnectionPoolBuilder<C extends TwitchPubSubConnectionPool, B extends TwitchPubSubConnectionPoolBuilder<C, B>>
    extends TwitchModuleConnectionPool.TwitchModuleConnectionPoolBuilder<TwitchPubSub, PubSubRequest, PubSubSubscription, Boolean, TwitchPubSubBuilder, C, B> {
        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "TwitchPubSubConnectionPool.TwitchPubSubConnectionPoolBuilder(super=" + super.toString() + ")";
        }
    }
}

