/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.config.Twitch4JGlobal;
import com.github.twitch4j.common.util.ThreadUtils;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.helix.TwitchHelixErrorDecoder;
import com.github.twitch4j.helix.interceptor.TwitchHelixClientIdInterceptor;
import com.github.twitch4j.helix.interceptor.TwitchHelixDecoder;
import com.github.twitch4j.helix.interceptor.TwitchHelixHttpClient;
import com.netflix.config.ConfigurationManager;
import feign.Client;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.hystrix.HystrixFeign;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchHelixBuilder {
    private static final Logger log = LoggerFactory.getLogger(TwitchHelixBuilder.class);
    private String clientId = Twitch4JGlobal.clientId;
    private String clientSecret = Twitch4JGlobal.clientSecret;
    private String userAgent = Twitch4JGlobal.userAgent;
    private OAuth2Credential defaultAuthToken = null;
    private Integer requestQueueSize = -1;
    private String baseUrl = "https://api.twitch.tv/helix";
    private Integer timeout = 5000;
    private Logger.Level logLevel = Logger.Level.NONE;
    private ProxyConfig proxyConfig = null;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = null;

    public static TwitchHelixBuilder builder() {
        return new TwitchHelixBuilder();
    }

    public TwitchHelix build() {
        log.debug("Helix: Initializing Module ...");
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.isolation.thread.timeoutInMilliseconds", (Object)this.timeout);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.requestCache.enabled", (Object)false);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.maxQueueSize", (Object)this.getRequestQueueSize());
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.queueSizeRejectionThreshold", (Object)this.getRequestQueueSize());
        ObjectMapper mapper = TypeConvert.getObjectMapper();
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (this.proxyConfig != null) {
            this.proxyConfig.apply(clientBuilder);
        }
        if (this.scheduledThreadPoolExecutor == null) {
            this.scheduledThreadPoolExecutor = ThreadUtils.getDefaultScheduledThreadPoolExecutor((String)("twitch4j-" + RandomStringUtils.random((int)4, (boolean)true, (boolean)true)), (Integer)1);
        }
        TwitchHelixClientIdInterceptor interceptor = new TwitchHelixClientIdInterceptor(this);
        return (TwitchHelix)HystrixFeign.builder().client((Client)new TwitchHelixHttpClient(new OkHttpClient(clientBuilder.build()), this.scheduledThreadPoolExecutor, interceptor, this.timeout)).encoder((Encoder)new JacksonEncoder(mapper)).decoder((Decoder)new TwitchHelixDecoder(mapper, interceptor)).logger((feign.Logger)new Slf4jLogger()).logLevel(this.logLevel).errorDecoder((ErrorDecoder)new TwitchHelixErrorDecoder((Decoder)new JacksonDecoder())).requestInterceptor((RequestInterceptor)interceptor).options(new Request.Options((long)(this.timeout / 3), TimeUnit.MILLISECONDS, (long)this.timeout.intValue(), TimeUnit.MILLISECONDS, true)).retryer((Retryer)new Retryer.Default(500L, (long)this.timeout.intValue(), 2)).target(TwitchHelix.class, this.baseUrl);
    }

    private TwitchHelixBuilder() {
    }

    private TwitchHelixBuilder(String clientId, String clientSecret, String userAgent, OAuth2Credential defaultAuthToken, Integer requestQueueSize, String baseUrl, Integer timeout, Logger.Level logLevel, ProxyConfig proxyConfig, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.userAgent = userAgent;
        this.defaultAuthToken = defaultAuthToken;
        this.requestQueueSize = requestQueueSize;
        this.baseUrl = baseUrl;
        this.timeout = timeout;
        this.logLevel = logLevel;
        this.proxyConfig = proxyConfig;
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public OAuth2Credential getDefaultAuthToken() {
        return this.defaultAuthToken;
    }

    public Integer getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Logger.Level getLogLevel() {
        return this.logLevel;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    public TwitchHelixBuilder withClientId(String clientId) {
        return this.clientId == clientId ? this : new TwitchHelixBuilder(clientId, this.clientSecret, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor);
    }

    public TwitchHelixBuilder withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new TwitchHelixBuilder(this.clientId, clientSecret, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor);
    }

    public TwitchHelixBuilder withUserAgent(String userAgent) {
        return this.userAgent == userAgent ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor);
    }

    public TwitchHelixBuilder withDefaultAuthToken(OAuth2Credential defaultAuthToken) {
        return this.defaultAuthToken == defaultAuthToken ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.userAgent, defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor);
    }

    public TwitchHelixBuilder withRequestQueueSize(Integer requestQueueSize) {
        return this.requestQueueSize == requestQueueSize ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.userAgent, this.defaultAuthToken, requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor);
    }

    public TwitchHelixBuilder withTimeout(Integer timeout) {
        return this.timeout == timeout ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor);
    }

    public TwitchHelixBuilder withLogLevel(Logger.Level logLevel) {
        return this.logLevel == logLevel ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor);
    }

    public TwitchHelixBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, proxyConfig, this.scheduledThreadPoolExecutor);
    }

    public TwitchHelixBuilder withScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        return this.scheduledThreadPoolExecutor == scheduledThreadPoolExecutor ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, scheduledThreadPoolExecutor);
    }
}

