/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.github.twitch4j.eventsub.ConduitShard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=ShardsInputBuilder.class)
public class ShardsInput {
    @NotNull
    private String conduitId;
    @NotNull
    private Collection<ConduitShard> shards;

    @Generated
    public static ShardsInputBuilder builder() {
        return new ShardsInputBuilder();
    }

    @Generated
    public ShardsInputBuilder toBuilder() {
        ShardsInputBuilder builder = new ShardsInputBuilder().conduitId(this.conduitId);
        if (this.shards != null) {
            builder.shards(this.shards);
        }
        return builder;
    }

    @Generated
    public ShardsInput withConduitId(@NotNull String conduitId) {
        if (conduitId == null) {
            throw new NullPointerException("conduitId is marked non-null but is null");
        }
        return this.conduitId == conduitId ? this : new ShardsInput(conduitId, this.shards);
    }

    @Generated
    public ShardsInput withShards(@NotNull Collection<ConduitShard> shards) {
        if (shards == null) {
            throw new NullPointerException("shards is marked non-null but is null");
        }
        return this.shards == shards ? this : new ShardsInput(this.conduitId, shards);
    }

    @NotNull
    @Generated
    public String getConduitId() {
        return this.conduitId;
    }

    @NotNull
    @Generated
    public Collection<ConduitShard> getShards() {
        return this.shards;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardsInput)) {
            return false;
        }
        ShardsInput other = (ShardsInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$conduitId = this.getConduitId();
        String other$conduitId = other.getConduitId();
        if (this$conduitId == null ? other$conduitId != null : !this$conduitId.equals(other$conduitId)) {
            return false;
        }
        Collection<ConduitShard> this$shards = this.getShards();
        Collection<ConduitShard> other$shards = other.getShards();
        return !(this$shards == null ? other$shards != null : !((Object)this$shards).equals(other$shards));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ShardsInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $conduitId = this.getConduitId();
        result = result * 59 + ($conduitId == null ? 43 : $conduitId.hashCode());
        Collection<ConduitShard> $shards = this.getShards();
        result = result * 59 + ($shards == null ? 43 : ((Object)$shards).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ShardsInput(conduitId=" + this.getConduitId() + ", shards=" + this.getShards() + ")";
    }

    @Generated
    private void setConduitId(@NotNull String conduitId) {
        if (conduitId == null) {
            throw new NullPointerException("conduitId is marked non-null but is null");
        }
        this.conduitId = conduitId;
    }

    @Generated
    private void setShards(@NotNull Collection<ConduitShard> shards) {
        if (shards == null) {
            throw new NullPointerException("shards is marked non-null but is null");
        }
        this.shards = shards;
    }

    @Generated
    public ShardsInput() {
    }

    @Generated
    public ShardsInput(@NotNull String conduitId, @NotNull Collection<ConduitShard> shards) {
        if (conduitId == null) {
            throw new NullPointerException("conduitId is marked non-null but is null");
        }
        if (shards == null) {
            throw new NullPointerException("shards is marked non-null but is null");
        }
        this.conduitId = conduitId;
        this.shards = shards;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class ShardsInputBuilder {
        @Generated
        private String conduitId;
        @Generated
        private ArrayList<ConduitShard> shards;

        @Generated
        ShardsInputBuilder() {
        }

        @Generated
        public ShardsInputBuilder conduitId(@NotNull String conduitId) {
            if (conduitId == null) {
                throw new NullPointerException("conduitId is marked non-null but is null");
            }
            this.conduitId = conduitId;
            return this;
        }

        @Generated
        public ShardsInputBuilder shard(ConduitShard shard) {
            if (this.shards == null) {
                this.shards = new ArrayList();
            }
            this.shards.add(shard);
            return this;
        }

        @Generated
        public ShardsInputBuilder shards(Collection<? extends ConduitShard> shards) {
            if (shards == null) {
                throw new NullPointerException("shards cannot be null");
            }
            if (this.shards == null) {
                this.shards = new ArrayList();
            }
            this.shards.addAll(shards);
            return this;
        }

        @Generated
        public ShardsInputBuilder clearShards() {
            if (this.shards != null) {
                this.shards.clear();
            }
            return this;
        }

        @Generated
        public ShardsInput build() {
            List<ConduitShard> shards;
            switch (this.shards == null ? 0 : this.shards.size()) {
                case 0: {
                    shards = Collections.emptyList();
                    break;
                }
                case 1: {
                    shards = Collections.singletonList(this.shards.get(0));
                    break;
                }
                default: {
                    shards = Collections.unmodifiableList(new ArrayList<ConduitShard>(this.shards));
                }
            }
            return new ShardsInput(this.conduitId, shards);
        }

        @Generated
        public String toString() {
            return "ShardsInput.ShardsInputBuilder(conduitId=" + this.conduitId + ", shards=" + this.shards + ")";
        }
    }
}

