/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql.internal;

import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.InputFieldMarshaller;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.OperationRequestBodyComposer;
import com.apollographql.apollo.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.ResponseReader;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.github.twitch4j.graphql.internal.type.CustomType;
import com.github.twitch4j.graphql.internal.type.UnbanRequestStatus;
import com.github.twitch4j.graphql.internal.type.UnbanRequestsSortOrder;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FetchUnbanRequestsQuery
implements Query<Data, Data, Variables> {
    public static final String OPERATION_ID = "3a67e01dc74b57c770c66b0028e5cf278c76a7304a9ff920dbf52e1d2d6bbc95";
    public static final String QUERY_DOCUMENT = QueryDocumentMinifier.minify((String)"query fetchUnbanRequests($channelLogin: String!, $after: Cursor, $first: Int = 25, $order: UnbanRequestsSortOrder = NEWEST, $status: UnbanRequestStatus = PENDING, $userId: ID) {\n  channel(name: $channelLogin) {\n    __typename\n    id\n    unbanRequests(after: $after, first: $first, options: {order: $order, status: $status, userID: $userId}) {\n      __typename\n      edges {\n        __typename\n        cursor\n        node {\n          __typename\n          createdAt\n          id\n          requester {\n            __typename\n            id\n            login\n            displayName\n            profileImageURL(width: 50)\n          }\n          requesterMessage\n          resolvedAt\n          resolvedBy {\n            __typename\n            id\n            login\n            displayName\n          }\n          resolverMessage\n          status\n        }\n      }\n      pageInfo {\n        __typename\n        hasNextPage\n      }\n      totalCount(status: $status)\n    }\n    unbanRequestsSettings {\n      __typename\n      cooldownMinutes\n      isEnabled\n    }\n  }\n}");
    public static final OperationName OPERATION_NAME = new OperationName(){

        public String name() {
            return "fetchUnbanRequests";
        }
    };
    private final Variables variables;

    public FetchUnbanRequestsQuery(@NotNull String channelLogin, @NotNull Input<Object> after, @NotNull Input<Integer> first, @NotNull Input<UnbanRequestsSortOrder> order, @NotNull Input<UnbanRequestStatus> status, @NotNull Input<String> userId) {
        Utils.checkNotNull((Object)channelLogin, (Object)"channelLogin == null");
        Utils.checkNotNull(after, (Object)"after == null");
        Utils.checkNotNull(first, (Object)"first == null");
        Utils.checkNotNull(order, (Object)"order == null");
        Utils.checkNotNull(status, (Object)"status == null");
        Utils.checkNotNull(userId, (Object)"userId == null");
        this.variables = new Variables(channelLogin, after, first, order, status, userId);
    }

    public String operationId() {
        return OPERATION_ID;
    }

    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    public Data wrapData(Data data) {
        return data;
    }

    public Variables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public OperationName name() {
        return OPERATION_NAME;
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return SimpleOperationResponseParser.parse((BufferedSource)source, (Operation)this, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return this.parse((BufferedSource)new Buffer().write(byteString), scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source) throws IOException {
        return this.parse(source, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString) throws IOException {
        return this.parse(byteString, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(@NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public ByteString composeRequestBody() {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(boolean autoPersistQueries, boolean withQueryDocument, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)autoPersistQueries, (boolean)withQueryDocument, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    public static final class Variables
    extends Operation.Variables {
        @NotNull
        private final String channelLogin;
        private final Input<Object> after;
        private final Input<Integer> first;
        private final Input<UnbanRequestsSortOrder> order;
        private final Input<UnbanRequestStatus> status;
        private final Input<String> userId;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(@NotNull String channelLogin, Input<Object> after, Input<Integer> first, Input<UnbanRequestsSortOrder> order, Input<UnbanRequestStatus> status, Input<String> userId) {
            this.channelLogin = channelLogin;
            this.after = after;
            this.first = first;
            this.order = order;
            this.status = status;
            this.userId = userId;
            this.valueMap.put("channelLogin", channelLogin);
            if (after.defined) {
                this.valueMap.put("after", after.value);
            }
            if (first.defined) {
                this.valueMap.put("first", first.value);
            }
            if (order.defined) {
                this.valueMap.put("order", order.value);
            }
            if (status.defined) {
                this.valueMap.put("status", status.value);
            }
            if (userId.defined) {
                this.valueMap.put("userId", userId.value);
            }
        }

        @NotNull
        public String channelLogin() {
            return this.channelLogin;
        }

        public Input<Object> after() {
            return this.after;
        }

        public Input<Integer> first() {
            return this.first;
        }

        public Input<UnbanRequestsSortOrder> order() {
            return this.order;
        }

        public Input<UnbanRequestStatus> status() {
            return this.status;
        }

        public Input<String> userId() {
            return this.userId;
        }

        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                public void marshal(InputFieldWriter writer) throws IOException {
                    writer.writeString("channelLogin", channelLogin);
                    if (((Variables)this).after.defined) {
                        writer.writeCustom("after", (ScalarType)CustomType.CURSOR, ((Variables)this).after.value != null ? ((Variables)this).after.value : null);
                    }
                    if (((Variables)this).first.defined) {
                        writer.writeInt("first", (Integer)((Variables)this).first.value);
                    }
                    if (((Variables)this).order.defined) {
                        writer.writeString("order", ((Variables)this).order.value != null ? ((UnbanRequestsSortOrder)((Object)((Variables)this).order.value)).rawValue() : null);
                    }
                    if (((Variables)this).status.defined) {
                        writer.writeString("status", ((Variables)this).status.value != null ? ((UnbanRequestStatus)((Object)((Variables)this).status.value)).rawValue() : null);
                    }
                    if (((Variables)this).userId.defined) {
                        writer.writeCustom("userId", (ScalarType)CustomType.ID, ((Variables)this).userId.value != null ? ((Variables)this).userId.value : null);
                    }
                }
            };
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject((String)"channel", (String)"channel", (Map)new UnmodifiableMapBuilder(1).put((Object)"name", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"channelLogin").build()).build(), (boolean)true, Collections.emptyList())};
        @Nullable
        final Channel channel;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@Nullable Channel channel) {
            this.channel = channel;
        }

        @Nullable
        public Channel channel() {
            return this.channel;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], channel != null ? channel.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{channel=" + this.channel + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.channel == null ? that.channel == null : this.channel.equals(that.channel);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.channel == null ? 0 : this.channel.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final Channel.Mapper channelFieldMapper = new Channel.Mapper();

            public Data map(ResponseReader reader) {
                Channel channel = (Channel)reader.readObject($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Channel>(){

                    public Channel read(ResponseReader reader) {
                        return channelFieldMapper.map(reader);
                    }
                });
                return new Data(channel);
            }
        }
    }

    public static final class Builder {
        @NotNull
        private String channelLogin;
        private Input<Object> after = Input.absent();
        private Input<Integer> first = Input.absent();
        private Input<UnbanRequestsSortOrder> order = Input.absent();
        private Input<UnbanRequestStatus> status = Input.absent();
        private Input<String> userId = Input.absent();

        Builder() {
        }

        public Builder channelLogin(@NotNull String channelLogin) {
            this.channelLogin = channelLogin;
            return this;
        }

        public Builder after(@Nullable Object after) {
            this.after = Input.fromNullable((Object)after);
            return this;
        }

        public Builder first(@Nullable Integer first) {
            this.first = Input.fromNullable((Object)first);
            return this;
        }

        public Builder order(@Nullable UnbanRequestsSortOrder order) {
            this.order = Input.fromNullable((Object)((Object)order));
            return this;
        }

        public Builder status(@Nullable UnbanRequestStatus status) {
            this.status = Input.fromNullable((Object)((Object)status));
            return this;
        }

        public Builder userId(@Nullable String userId) {
            this.userId = Input.fromNullable((Object)userId);
            return this;
        }

        public Builder afterInput(@NotNull Input<Object> after) {
            this.after = (Input)Utils.checkNotNull(after, (Object)"after == null");
            return this;
        }

        public Builder firstInput(@NotNull Input<Integer> first) {
            this.first = (Input)Utils.checkNotNull(first, (Object)"first == null");
            return this;
        }

        public Builder orderInput(@NotNull Input<UnbanRequestsSortOrder> order) {
            this.order = (Input)Utils.checkNotNull(order, (Object)"order == null");
            return this;
        }

        public Builder statusInput(@NotNull Input<UnbanRequestStatus> status) {
            this.status = (Input)Utils.checkNotNull(status, (Object)"status == null");
            return this;
        }

        public Builder userIdInput(@NotNull Input<String> userId) {
            this.userId = (Input)Utils.checkNotNull(userId, (Object)"userId == null");
            return this;
        }

        public FetchUnbanRequestsQuery build() {
            Utils.checkNotNull((Object)this.channelLogin, (Object)"channelLogin == null");
            return new FetchUnbanRequestsQuery(this.channelLogin, this.after, this.first, this.order, this.status, this.userId);
        }
    }

    public static class UnbanRequestsSettings {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"cooldownMinutes", (String)"cooldownMinutes", null, (boolean)false, Collections.emptyList()), ResponseField.forBoolean((String)"isEnabled", (String)"isEnabled", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        final int cooldownMinutes;
        final boolean isEnabled;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public UnbanRequestsSettings(@NotNull String __typename, int cooldownMinutes, boolean isEnabled) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.cooldownMinutes = cooldownMinutes;
            this.isEnabled = isEnabled;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        public int cooldownMinutes() {
            return this.cooldownMinutes;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeInt($responseFields[1], Integer.valueOf(cooldownMinutes));
                    writer.writeBoolean($responseFields[2], Boolean.valueOf(isEnabled));
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "UnbanRequestsSettings{__typename=" + this.__typename + ", cooldownMinutes=" + this.cooldownMinutes + ", isEnabled=" + this.isEnabled + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof UnbanRequestsSettings) {
                UnbanRequestsSettings that = (UnbanRequestsSettings)o;
                return this.__typename.equals(that.__typename) && this.cooldownMinutes == that.cooldownMinutes && this.isEnabled == that.isEnabled;
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.cooldownMinutes;
                h *= 1000003;
                this.$hashCode = h ^= Boolean.valueOf(this.isEnabled).hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<UnbanRequestsSettings> {
            public UnbanRequestsSettings map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                int cooldownMinutes = reader.readInt($responseFields[1]);
                boolean isEnabled = reader.readBoolean($responseFields[2]);
                return new UnbanRequestsSettings(__typename, cooldownMinutes, isEnabled);
            }
        }
    }

    public static class PageInfo {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forBoolean((String)"hasNextPage", (String)"hasNextPage", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        final boolean hasNextPage;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public PageInfo(@NotNull String __typename, boolean hasNextPage) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.hasNextPage = hasNextPage;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        public boolean hasNextPage() {
            return this.hasNextPage;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeBoolean($responseFields[1], Boolean.valueOf(hasNextPage));
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "PageInfo{__typename=" + this.__typename + ", hasNextPage=" + this.hasNextPage + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PageInfo) {
                PageInfo that = (PageInfo)o;
                return this.__typename.equals(that.__typename) && this.hasNextPage == that.hasNextPage;
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= Boolean.valueOf(this.hasNextPage).hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<PageInfo> {
            public PageInfo map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                boolean hasNextPage = reader.readBoolean($responseFields[1]);
                return new PageInfo(__typename, hasNextPage);
            }
        }
    }

    public static class ResolvedBy {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String login;
        @NotNull
        final String displayName;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public ResolvedBy(@NotNull String __typename, @NotNull String id, @NotNull String login, @NotNull String displayName) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], login);
                    writer.writeString($responseFields[3], displayName);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "ResolvedBy{__typename=" + this.__typename + ", id=" + this.id + ", login=" + this.login + ", displayName=" + this.displayName + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ResolvedBy) {
                ResolvedBy that = (ResolvedBy)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.login.equals(that.login) && this.displayName.equals(that.displayName);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.login.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.displayName.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<ResolvedBy> {
            public ResolvedBy map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String login = reader.readString($responseFields[2]);
                String displayName = reader.readString($responseFields[3]);
                return new ResolvedBy(__typename, id, login, displayName);
            }
        }
    }

    public static class Requester {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"profileImageURL", (String)"profileImageURL", (Map)new UnmodifiableMapBuilder(1).put((Object)"width", (Object)50).build(), (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String login;
        @NotNull
        final String displayName;
        @Nullable
        final String profileImageURL;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Requester(@NotNull String __typename, @NotNull String id, @NotNull String login, @NotNull String displayName, @Nullable String profileImageURL) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
            this.profileImageURL = profileImageURL;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        @Nullable
        public String profileImageURL() {
            return this.profileImageURL;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], login);
                    writer.writeString($responseFields[3], displayName);
                    writer.writeString($responseFields[4], profileImageURL);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Requester{__typename=" + this.__typename + ", id=" + this.id + ", login=" + this.login + ", displayName=" + this.displayName + ", profileImageURL=" + this.profileImageURL + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Requester) {
                Requester that = (Requester)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.login.equals(that.login) && this.displayName.equals(that.displayName) && (this.profileImageURL == null ? that.profileImageURL == null : this.profileImageURL.equals(that.profileImageURL));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.login.hashCode();
                h *= 1000003;
                h ^= this.displayName.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.profileImageURL == null ? 0 : this.profileImageURL.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Requester> {
            public Requester map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String login = reader.readString($responseFields[2]);
                String displayName = reader.readString($responseFields[3]);
                String profileImageURL = reader.readString($responseFields[4]);
                return new Requester(__typename, id, login, displayName, profileImageURL);
            }
        }
    }

    public static class Node {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"createdAt", (String)"createdAt", null, (boolean)false, (ScalarType)CustomType.TIME, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forObject((String)"requester", (String)"requester", null, (boolean)true, Collections.emptyList()), ResponseField.forString((String)"requesterMessage", (String)"requesterMessage", null, (boolean)true, Collections.emptyList()), ResponseField.forCustomType((String)"resolvedAt", (String)"resolvedAt", null, (boolean)true, (ScalarType)CustomType.TIME, Collections.emptyList()), ResponseField.forObject((String)"resolvedBy", (String)"resolvedBy", null, (boolean)true, Collections.emptyList()), ResponseField.forString((String)"resolverMessage", (String)"resolverMessage", null, (boolean)true, Collections.emptyList()), ResponseField.forString((String)"status", (String)"status", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final Object createdAt;
        @NotNull
        final String id;
        @Nullable
        final Requester requester;
        @Nullable
        final String requesterMessage;
        @Nullable
        final Object resolvedAt;
        @Nullable
        final ResolvedBy resolvedBy;
        @Nullable
        final String resolverMessage;
        @NotNull
        final UnbanRequestStatus status;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Node(@NotNull String __typename, @NotNull Object createdAt, @NotNull String id, @Nullable Requester requester, @Nullable String requesterMessage, @Nullable Object resolvedAt, @Nullable ResolvedBy resolvedBy, @Nullable String resolverMessage, @NotNull UnbanRequestStatus status) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.createdAt = Utils.checkNotNull((Object)createdAt, (Object)"createdAt == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.requester = requester;
            this.requesterMessage = requesterMessage;
            this.resolvedAt = resolvedAt;
            this.resolvedBy = resolvedBy;
            this.resolverMessage = resolverMessage;
            this.status = (UnbanRequestStatus)((Object)Utils.checkNotNull((Object)((Object)status), (Object)"status == null"));
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public Object createdAt() {
            return this.createdAt;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @Nullable
        public Requester requester() {
            return this.requester;
        }

        @Nullable
        public String requesterMessage() {
            return this.requesterMessage;
        }

        @Nullable
        public Object resolvedAt() {
            return this.resolvedAt;
        }

        @Nullable
        public ResolvedBy resolvedBy() {
            return this.resolvedBy;
        }

        @Nullable
        public String resolverMessage() {
            return this.resolverMessage;
        }

        @NotNull
        public UnbanRequestStatus status() {
            return this.status;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], createdAt);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[2], (Object)id);
                    writer.writeObject($responseFields[3], requester != null ? requester.marshaller() : null);
                    writer.writeString($responseFields[4], requesterMessage);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[5], resolvedAt);
                    writer.writeObject($responseFields[6], resolvedBy != null ? resolvedBy.marshaller() : null);
                    writer.writeString($responseFields[7], resolverMessage);
                    writer.writeString($responseFields[8], status.rawValue());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Node{__typename=" + this.__typename + ", createdAt=" + this.createdAt + ", id=" + this.id + ", requester=" + this.requester + ", requesterMessage=" + this.requesterMessage + ", resolvedAt=" + this.resolvedAt + ", resolvedBy=" + this.resolvedBy + ", resolverMessage=" + this.resolverMessage + ", status=" + (Object)((Object)this.status) + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Node) {
                Node that = (Node)o;
                return this.__typename.equals(that.__typename) && this.createdAt.equals(that.createdAt) && this.id.equals(that.id) && (this.requester == null ? that.requester == null : this.requester.equals(that.requester)) && (this.requesterMessage == null ? that.requesterMessage == null : this.requesterMessage.equals(that.requesterMessage)) && (this.resolvedAt == null ? that.resolvedAt == null : this.resolvedAt.equals(that.resolvedAt)) && (this.resolvedBy == null ? that.resolvedBy == null : this.resolvedBy.equals(that.resolvedBy)) && (this.resolverMessage == null ? that.resolverMessage == null : this.resolverMessage.equals(that.resolverMessage)) && this.status.equals((Object)that.status);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.createdAt.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.requester == null ? 0 : this.requester.hashCode();
                h *= 1000003;
                h ^= this.requesterMessage == null ? 0 : this.requesterMessage.hashCode();
                h *= 1000003;
                h ^= this.resolvedAt == null ? 0 : this.resolvedAt.hashCode();
                h *= 1000003;
                h ^= this.resolvedBy == null ? 0 : this.resolvedBy.hashCode();
                h *= 1000003;
                h ^= this.resolverMessage == null ? 0 : this.resolverMessage.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.status.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Node> {
            final Requester.Mapper requesterFieldMapper = new Requester.Mapper();
            final ResolvedBy.Mapper resolvedByFieldMapper = new ResolvedBy.Mapper();

            public Node map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Object createdAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[2]);
                Requester requester = (Requester)reader.readObject($responseFields[3], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Requester>(){

                    public Requester read(ResponseReader reader) {
                        return requesterFieldMapper.map(reader);
                    }
                });
                String requesterMessage = reader.readString($responseFields[4]);
                Object resolvedAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[5]);
                ResolvedBy resolvedBy = (ResolvedBy)reader.readObject($responseFields[6], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<ResolvedBy>(){

                    public ResolvedBy read(ResponseReader reader) {
                        return resolvedByFieldMapper.map(reader);
                    }
                });
                String resolverMessage = reader.readString($responseFields[7]);
                String statusStr = reader.readString($responseFields[8]);
                UnbanRequestStatus status = statusStr != null ? UnbanRequestStatus.safeValueOf(statusStr) : null;
                return new Node(__typename, createdAt, id, requester, requesterMessage, resolvedAt, resolvedBy, resolverMessage, status);
            }
        }
    }

    public static class Edge {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"cursor", (String)"cursor", null, (boolean)false, (ScalarType)CustomType.CURSOR, Collections.emptyList()), ResponseField.forObject((String)"node", (String)"node", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final Object cursor;
        @Nullable
        final Node node;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Edge(@NotNull String __typename, @NotNull Object cursor, @Nullable Node node) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.cursor = Utils.checkNotNull((Object)cursor, (Object)"cursor == null");
            this.node = node;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public Object cursor() {
            return this.cursor;
        }

        @Nullable
        public Node node() {
            return this.node;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], cursor);
                    writer.writeObject($responseFields[2], node != null ? node.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Edge{__typename=" + this.__typename + ", cursor=" + this.cursor + ", node=" + this.node + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Edge) {
                Edge that = (Edge)o;
                return this.__typename.equals(that.__typename) && this.cursor.equals(that.cursor) && (this.node == null ? that.node == null : this.node.equals(that.node));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.cursor.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.node == null ? 0 : this.node.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Edge> {
            final Node.Mapper nodeFieldMapper = new Node.Mapper();

            public Edge map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Object cursor = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                Node node = (Node)reader.readObject($responseFields[2], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Node>(){

                    public Node read(ResponseReader reader) {
                        return nodeFieldMapper.map(reader);
                    }
                });
                return new Edge(__typename, cursor, node);
            }
        }
    }

    public static class UnbanRequests {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"edges", (String)"edges", null, (boolean)true, Collections.emptyList()), ResponseField.forObject((String)"pageInfo", (String)"pageInfo", null, (boolean)false, Collections.emptyList()), ResponseField.forDouble((String)"totalCount", (String)"totalCount", (Map)new UnmodifiableMapBuilder(1).put((Object)"status", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"status").build()).build(), (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final List<Edge> edges;
        @NotNull
        final PageInfo pageInfo;
        @Nullable
        final Double totalCount;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public UnbanRequests(@NotNull String __typename, @Nullable List<Edge> edges, @NotNull PageInfo pageInfo, @Nullable Double totalCount) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.edges = edges;
            this.pageInfo = (PageInfo)Utils.checkNotNull((Object)pageInfo, (Object)"pageInfo == null");
            this.totalCount = totalCount;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public List<Edge> edges() {
            return this.edges;
        }

        @NotNull
        public PageInfo pageInfo() {
            return this.pageInfo;
        }

        @Nullable
        public Double totalCount() {
            return this.totalCount;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], edges, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Edge)item).marshaller());
                            }
                        }
                    });
                    writer.writeObject($responseFields[2], pageInfo.marshaller());
                    writer.writeDouble($responseFields[3], totalCount);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "UnbanRequests{__typename=" + this.__typename + ", edges=" + this.edges + ", pageInfo=" + this.pageInfo + ", totalCount=" + this.totalCount + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof UnbanRequests) {
                UnbanRequests that = (UnbanRequests)o;
                return this.__typename.equals(that.__typename) && (this.edges == null ? that.edges == null : this.edges.equals(that.edges)) && this.pageInfo.equals(that.pageInfo) && (this.totalCount == null ? that.totalCount == null : this.totalCount.equals(that.totalCount));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.edges == null ? 0 : this.edges.hashCode();
                h *= 1000003;
                h ^= this.pageInfo.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.totalCount == null ? 0 : this.totalCount.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<UnbanRequests> {
            final Edge.Mapper edgeFieldMapper = new Edge.Mapper();
            final PageInfo.Mapper pageInfoFieldMapper = new PageInfo.Mapper();

            public UnbanRequests map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List edges = reader.readList($responseFields[1], (ResponseReader.ListReader)new ResponseReader.ListReader<Edge>(){

                    public Edge read(ResponseReader.ListItemReader listItemReader) {
                        return (Edge)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Edge>(){

                            public Edge read(ResponseReader reader) {
                                return edgeFieldMapper.map(reader);
                            }
                        });
                    }
                });
                PageInfo pageInfo = (PageInfo)reader.readObject($responseFields[2], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<PageInfo>(){

                    public PageInfo read(ResponseReader reader) {
                        return pageInfoFieldMapper.map(reader);
                    }
                });
                Double totalCount = reader.readDouble($responseFields[3]);
                return new UnbanRequests(__typename, edges, pageInfo, totalCount);
            }
        }
    }

    public static class Channel {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forObject((String)"unbanRequests", (String)"unbanRequests", (Map)new UnmodifiableMapBuilder(3).put((Object)"after", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"after").build()).put((Object)"first", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"first").build()).put((Object)"options", (Object)new UnmodifiableMapBuilder(3).put((Object)"order", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"order").build()).put((Object)"status", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"status").build()).put((Object)"userID", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"userId").build()).build()).build(), (boolean)true, Collections.emptyList()), ResponseField.forObject((String)"unbanRequestsSettings", (String)"unbanRequestsSettings", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @Nullable
        final UnbanRequests unbanRequests;
        @Nullable
        final UnbanRequestsSettings unbanRequestsSettings;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Channel(@NotNull String __typename, @NotNull String id, @Nullable UnbanRequests unbanRequests, @Nullable UnbanRequestsSettings unbanRequestsSettings) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.unbanRequests = unbanRequests;
            this.unbanRequestsSettings = unbanRequestsSettings;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @Nullable
        public UnbanRequests unbanRequests() {
            return this.unbanRequests;
        }

        @Nullable
        public UnbanRequestsSettings unbanRequestsSettings() {
            return this.unbanRequestsSettings;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeObject($responseFields[2], unbanRequests != null ? unbanRequests.marshaller() : null);
                    writer.writeObject($responseFields[3], unbanRequestsSettings != null ? unbanRequestsSettings.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Channel{__typename=" + this.__typename + ", id=" + this.id + ", unbanRequests=" + this.unbanRequests + ", unbanRequestsSettings=" + this.unbanRequestsSettings + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Channel) {
                Channel that = (Channel)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && (this.unbanRequests == null ? that.unbanRequests == null : this.unbanRequests.equals(that.unbanRequests)) && (this.unbanRequestsSettings == null ? that.unbanRequestsSettings == null : this.unbanRequestsSettings.equals(that.unbanRequestsSettings));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.unbanRequests == null ? 0 : this.unbanRequests.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.unbanRequestsSettings == null ? 0 : this.unbanRequestsSettings.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Channel> {
            final UnbanRequests.Mapper unbanRequestsFieldMapper = new UnbanRequests.Mapper();
            final UnbanRequestsSettings.Mapper unbanRequestsSettingsFieldMapper = new UnbanRequestsSettings.Mapper();

            public Channel map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                UnbanRequests unbanRequests = (UnbanRequests)reader.readObject($responseFields[2], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<UnbanRequests>(){

                    public UnbanRequests read(ResponseReader reader) {
                        return unbanRequestsFieldMapper.map(reader);
                    }
                });
                UnbanRequestsSettings unbanRequestsSettings = (UnbanRequestsSettings)reader.readObject($responseFields[3], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<UnbanRequestsSettings>(){

                    public UnbanRequestsSettings read(ResponseReader reader) {
                        return unbanRequestsSettingsFieldMapper.map(reader);
                    }
                });
                return new Channel(__typename, id, unbanRequests, unbanRequestsSettings);
            }
        }
    }
}

