/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql.internal;

import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.InputFieldMarshaller;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.OperationRequestBodyComposer;
import com.apollographql.apollo.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.ResponseReader;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.github.twitch4j.graphql.internal.type.CustomType;
import com.github.twitch4j.graphql.internal.type.EmoteType;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FetchUserEmoteSetsQuery
implements Query<Data, Data, Variables> {
    public static final String OPERATION_ID = "a82d6831cab6455d91b299fb745ca71585fccd8a2a0502d1f6caa6d00b26ab7a";
    public static final String QUERY_DOCUMENT = QueryDocumentMinifier.minify((String)"query fetchUserEmoteSets($id: ID) {\n  user(id: $id) {\n    __typename\n    emoteSets {\n      __typename\n      emotes {\n        __typename\n        id\n        modifiers {\n          __typename\n          code\n        }\n        setID\n        token\n        type\n      }\n      id\n      owner {\n        __typename\n        id\n        login\n        displayName\n        profileImageURL(width: 50)\n      }\n    }\n  }\n}");
    public static final OperationName OPERATION_NAME = new OperationName(){

        public String name() {
            return "fetchUserEmoteSets";
        }
    };
    private final Variables variables;

    public FetchUserEmoteSetsQuery(@NotNull Input<String> id) {
        Utils.checkNotNull(id, (Object)"id == null");
        this.variables = new Variables(id);
    }

    public String operationId() {
        return OPERATION_ID;
    }

    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    public Data wrapData(Data data) {
        return data;
    }

    public Variables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public OperationName name() {
        return OPERATION_NAME;
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return SimpleOperationResponseParser.parse((BufferedSource)source, (Operation)this, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return this.parse((BufferedSource)new Buffer().write(byteString), scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source) throws IOException {
        return this.parse(source, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString) throws IOException {
        return this.parse(byteString, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(@NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public ByteString composeRequestBody() {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(boolean autoPersistQueries, boolean withQueryDocument, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)autoPersistQueries, (boolean)withQueryDocument, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    public static final class Variables
    extends Operation.Variables {
        private final Input<String> id;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(Input<String> id) {
            this.id = id;
            if (id.defined) {
                this.valueMap.put("id", id.value);
            }
        }

        public Input<String> id() {
            return this.id;
        }

        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                public void marshal(InputFieldWriter writer) throws IOException {
                    if (((Variables)this).id.defined) {
                        writer.writeCustom("id", (ScalarType)CustomType.ID, ((Variables)this).id.value != null ? ((Variables)this).id.value : null);
                    }
                }
            };
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject((String)"user", (String)"user", (Map)new UnmodifiableMapBuilder(1).put((Object)"id", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"id").build()).build(), (boolean)true, Collections.emptyList())};
        @Nullable
        final User user;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@Nullable User user) {
            this.user = user;
        }

        @Nullable
        public User user() {
            return this.user;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], user != null ? user.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{user=" + this.user + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.user == null ? that.user == null : this.user.equals(that.user);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.user == null ? 0 : this.user.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final User.Mapper userFieldMapper = new User.Mapper();

            public Data map(ResponseReader reader) {
                User user = (User)reader.readObject($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<User>(){

                    public User read(ResponseReader reader) {
                        return userFieldMapper.map(reader);
                    }
                });
                return new Data(user);
            }
        }
    }

    public static final class Builder {
        private Input<String> id = Input.absent();

        Builder() {
        }

        public Builder id(@Nullable String id) {
            this.id = Input.fromNullable((Object)id);
            return this;
        }

        public Builder idInput(@NotNull Input<String> id) {
            this.id = (Input)Utils.checkNotNull(id, (Object)"id == null");
            return this;
        }

        public FetchUserEmoteSetsQuery build() {
            return new FetchUserEmoteSetsQuery(this.id);
        }
    }

    public static class Owner {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"profileImageURL", (String)"profileImageURL", (Map)new UnmodifiableMapBuilder(1).put((Object)"width", (Object)50).build(), (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String login;
        @NotNull
        final String displayName;
        @Nullable
        final String profileImageURL;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Owner(@NotNull String __typename, @NotNull String id, @NotNull String login, @NotNull String displayName, @Nullable String profileImageURL) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
            this.profileImageURL = profileImageURL;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        @Nullable
        public String profileImageURL() {
            return this.profileImageURL;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], login);
                    writer.writeString($responseFields[3], displayName);
                    writer.writeString($responseFields[4], profileImageURL);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Owner{__typename=" + this.__typename + ", id=" + this.id + ", login=" + this.login + ", displayName=" + this.displayName + ", profileImageURL=" + this.profileImageURL + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Owner) {
                Owner that = (Owner)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.login.equals(that.login) && this.displayName.equals(that.displayName) && (this.profileImageURL == null ? that.profileImageURL == null : this.profileImageURL.equals(that.profileImageURL));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.login.hashCode();
                h *= 1000003;
                h ^= this.displayName.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.profileImageURL == null ? 0 : this.profileImageURL.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Owner> {
            public Owner map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String login = reader.readString($responseFields[2]);
                String displayName = reader.readString($responseFields[3]);
                String profileImageURL = reader.readString($responseFields[4]);
                return new Owner(__typename, id, login, displayName, profileImageURL);
            }
        }
    }

    public static class Modifier {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"code", (String)"code", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String code;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Modifier(@NotNull String __typename, @NotNull String code) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.code = (String)Utils.checkNotNull((Object)code, (Object)"code == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String code() {
            return this.code;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], code);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Modifier{__typename=" + this.__typename + ", code=" + this.code + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Modifier) {
                Modifier that = (Modifier)o;
                return this.__typename.equals(that.__typename) && this.code.equals(that.code);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.code.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Modifier> {
            public Modifier map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String code = reader.readString($responseFields[1]);
                return new Modifier(__typename, code);
            }
        }
    }

    public static class Emote {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)true, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forList((String)"modifiers", (String)"modifiers", null, (boolean)true, Collections.emptyList()), ResponseField.forCustomType((String)"setID", (String)"setID", null, (boolean)true, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"token", (String)"token", null, (boolean)true, Collections.emptyList()), ResponseField.forString((String)"type", (String)"type", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final String id;
        @Nullable
        final List<Modifier> modifiers;
        @Nullable
        final String setID;
        @Nullable
        final String token;
        @Nullable
        final EmoteType type;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Emote(@NotNull String __typename, @Nullable String id, @Nullable List<Modifier> modifiers, @Nullable String setID, @Nullable String token, @Nullable EmoteType type) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = id;
            this.modifiers = modifiers;
            this.setID = setID;
            this.token = token;
            this.type = type;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public String id() {
            return this.id;
        }

        @Nullable
        public List<Modifier> modifiers() {
            return this.modifiers;
        }

        @Nullable
        public String setID() {
            return this.setID;
        }

        @Nullable
        public String token() {
            return this.token;
        }

        @Nullable
        public EmoteType type() {
            return this.type;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeList($responseFields[2], modifiers, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Modifier)item).marshaller());
                            }
                        }
                    });
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[3], (Object)setID);
                    writer.writeString($responseFields[4], token);
                    writer.writeString($responseFields[5], type != null ? type.rawValue() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Emote{__typename=" + this.__typename + ", id=" + this.id + ", modifiers=" + this.modifiers + ", setID=" + this.setID + ", token=" + this.token + ", type=" + (Object)((Object)this.type) + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Emote) {
                Emote that = (Emote)o;
                return this.__typename.equals(that.__typename) && (this.id == null ? that.id == null : this.id.equals(that.id)) && (this.modifiers == null ? that.modifiers == null : this.modifiers.equals(that.modifiers)) && (this.setID == null ? that.setID == null : this.setID.equals(that.setID)) && (this.token == null ? that.token == null : this.token.equals(that.token)) && (this.type == null ? that.type == null : this.type.equals((Object)that.type));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id == null ? 0 : this.id.hashCode();
                h *= 1000003;
                h ^= this.modifiers == null ? 0 : this.modifiers.hashCode();
                h *= 1000003;
                h ^= this.setID == null ? 0 : this.setID.hashCode();
                h *= 1000003;
                h ^= this.token == null ? 0 : this.token.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.type == null ? 0 : this.type.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Emote> {
            final Modifier.Mapper modifierFieldMapper = new Modifier.Mapper();

            public Emote map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                List modifiers = reader.readList($responseFields[2], (ResponseReader.ListReader)new ResponseReader.ListReader<Modifier>(){

                    public Modifier read(ResponseReader.ListItemReader listItemReader) {
                        return (Modifier)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Modifier>(){

                            public Modifier read(ResponseReader reader) {
                                return modifierFieldMapper.map(reader);
                            }
                        });
                    }
                });
                String setID = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[3]);
                String token = reader.readString($responseFields[4]);
                String typeStr = reader.readString($responseFields[5]);
                EmoteType type = typeStr != null ? EmoteType.safeValueOf(typeStr) : null;
                return new Emote(__typename, id, modifiers, setID, token, type);
            }
        }
    }

    public static class EmoteSet {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"emotes", (String)"emotes", null, (boolean)true, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)true, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forObject((String)"owner", (String)"owner", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final List<Emote> emotes;
        @Nullable
        final String id;
        @Nullable
        final Owner owner;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public EmoteSet(@NotNull String __typename, @Nullable List<Emote> emotes, @Nullable String id, @Nullable Owner owner) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.emotes = emotes;
            this.id = id;
            this.owner = owner;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public List<Emote> emotes() {
            return this.emotes;
        }

        @Nullable
        public String id() {
            return this.id;
        }

        @Nullable
        public Owner owner() {
            return this.owner;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], emotes, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Emote)item).marshaller());
                            }
                        }
                    });
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[2], (Object)id);
                    writer.writeObject($responseFields[3], owner != null ? owner.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "EmoteSet{__typename=" + this.__typename + ", emotes=" + this.emotes + ", id=" + this.id + ", owner=" + this.owner + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof EmoteSet) {
                EmoteSet that = (EmoteSet)o;
                return this.__typename.equals(that.__typename) && (this.emotes == null ? that.emotes == null : this.emotes.equals(that.emotes)) && (this.id == null ? that.id == null : this.id.equals(that.id)) && (this.owner == null ? that.owner == null : this.owner.equals(that.owner));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.emotes == null ? 0 : this.emotes.hashCode();
                h *= 1000003;
                h ^= this.id == null ? 0 : this.id.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.owner == null ? 0 : this.owner.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<EmoteSet> {
            final Emote.Mapper emoteFieldMapper = new Emote.Mapper();
            final Owner.Mapper ownerFieldMapper = new Owner.Mapper();

            public EmoteSet map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List emotes = reader.readList($responseFields[1], (ResponseReader.ListReader)new ResponseReader.ListReader<Emote>(){

                    public Emote read(ResponseReader.ListItemReader listItemReader) {
                        return (Emote)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Emote>(){

                            public Emote read(ResponseReader reader) {
                                return emoteFieldMapper.map(reader);
                            }
                        });
                    }
                });
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[2]);
                Owner owner = (Owner)reader.readObject($responseFields[3], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Owner>(){

                    public Owner read(ResponseReader reader) {
                        return ownerFieldMapper.map(reader);
                    }
                });
                return new EmoteSet(__typename, emotes, id, owner);
            }
        }
    }

    public static class User {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"emoteSets", (String)"emoteSets", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final List<EmoteSet> emoteSets;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public User(@NotNull String __typename, @Nullable List<EmoteSet> emoteSets) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.emoteSets = emoteSets;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public List<EmoteSet> emoteSets() {
            return this.emoteSets;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], emoteSets, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((EmoteSet)item).marshaller());
                            }
                        }
                    });
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "User{__typename=" + this.__typename + ", emoteSets=" + this.emoteSets + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof User) {
                User that = (User)o;
                return this.__typename.equals(that.__typename) && (this.emoteSets == null ? that.emoteSets == null : this.emoteSets.equals(that.emoteSets));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.emoteSets == null ? 0 : this.emoteSets.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<User> {
            final EmoteSet.Mapper emoteSetFieldMapper = new EmoteSet.Mapper();

            public User map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List emoteSets = reader.readList($responseFields[1], (ResponseReader.ListReader)new ResponseReader.ListReader<EmoteSet>(){

                    public EmoteSet read(ResponseReader.ListItemReader listItemReader) {
                        return (EmoteSet)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<EmoteSet>(){

                            public EmoteSet read(ResponseReader reader) {
                                return emoteSetFieldMapper.map(reader);
                            }
                        });
                    }
                });
                return new User(__typename, emoteSets);
            }
        }
    }
}

