/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql.internal;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.InputFieldMarshaller;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.OperationRequestBodyComposer;
import com.apollographql.apollo.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.ResponseReader;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.github.twitch4j.graphql.internal.type.CustomType;
import com.github.twitch4j.graphql.internal.type.PredictionEventStatus;
import com.github.twitch4j.graphql.internal.type.PredictionOutcomeColor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FetchLockedPredictionsQuery
implements Query<Data, Data, Variables> {
    public static final String OPERATION_ID = "231296649f73141cae95d0b4c7000e4c089bca7baf768b331754deb58e5ac19f";
    public static final String QUERY_DOCUMENT = QueryDocumentMinifier.minify((String)"query fetchLockedPredictions($channelId: ID!) {\n  channel(id: $channelId) {\n    __typename\n    lockedPredictionEvents {\n      __typename\n      createdAt\n      createdBy {\n        __typename\n        ... on User {\n          id\n          displayName\n          login\n        }\n      }\n      id\n      lockedAt\n      lockedBy {\n        __typename\n        ... on User {\n          id\n          displayName\n          login\n        }\n      }\n      outcomes {\n        __typename\n        color\n        id\n        title\n        topPredictors {\n          __typename\n          id\n          points\n          predictedAt\n          updatedAt\n          user {\n            __typename\n            id\n            displayName\n            login\n          }\n        }\n        totalPoints\n        totalUsers\n      }\n      predictionWindowSeconds\n      status\n      title\n    }\n  }\n}");
    public static final OperationName OPERATION_NAME = new OperationName(){

        public String name() {
            return "fetchLockedPredictions";
        }
    };
    private final Variables variables;

    public FetchLockedPredictionsQuery(@NotNull String channelId) {
        Utils.checkNotNull((Object)channelId, (Object)"channelId == null");
        this.variables = new Variables(channelId);
    }

    public String operationId() {
        return OPERATION_ID;
    }

    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    public Data wrapData(Data data) {
        return data;
    }

    public Variables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public OperationName name() {
        return OPERATION_NAME;
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return SimpleOperationResponseParser.parse((BufferedSource)source, (Operation)this, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return this.parse((BufferedSource)new Buffer().write(byteString), scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source) throws IOException {
        return this.parse(source, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString) throws IOException {
        return this.parse(byteString, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(@NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public ByteString composeRequestBody() {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(boolean autoPersistQueries, boolean withQueryDocument, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)autoPersistQueries, (boolean)withQueryDocument, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    public static final class Variables
    extends Operation.Variables {
        @NotNull
        private final String channelId;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(@NotNull String channelId) {
            this.channelId = channelId;
            this.valueMap.put("channelId", channelId);
        }

        @NotNull
        public String channelId() {
            return this.channelId;
        }

        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                public void marshal(InputFieldWriter writer) throws IOException {
                    writer.writeCustom("channelId", (ScalarType)CustomType.ID, (Object)channelId);
                }
            };
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject((String)"channel", (String)"channel", (Map)new UnmodifiableMapBuilder(1).put((Object)"id", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"channelId").build()).build(), (boolean)true, Collections.emptyList())};
        @Nullable
        final Channel channel;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@Nullable Channel channel) {
            this.channel = channel;
        }

        @Nullable
        public Channel channel() {
            return this.channel;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], channel != null ? channel.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{channel=" + this.channel + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.channel == null ? that.channel == null : this.channel.equals(that.channel);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.channel == null ? 0 : this.channel.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final Channel.Mapper channelFieldMapper = new Channel.Mapper();

            public Data map(ResponseReader reader) {
                Channel channel = (Channel)reader.readObject($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Channel>(){

                    public Channel read(ResponseReader reader) {
                        return channelFieldMapper.map(reader);
                    }
                });
                return new Data(channel);
            }
        }
    }

    public static final class Builder {
        @NotNull
        private String channelId;

        Builder() {
        }

        public Builder channelId(@NotNull String channelId) {
            this.channelId = channelId;
            return this;
        }

        public FetchLockedPredictionsQuery build() {
            Utils.checkNotNull((Object)this.channelId, (Object)"channelId == null");
            return new FetchLockedPredictionsQuery(this.channelId);
        }
    }

    public static class User {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String displayName;
        @NotNull
        final String login;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public User(@NotNull String __typename, @NotNull String id, @NotNull String displayName, @NotNull String login) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], displayName);
                    writer.writeString($responseFields[3], login);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "User{__typename=" + this.__typename + ", id=" + this.id + ", displayName=" + this.displayName + ", login=" + this.login + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof User) {
                User that = (User)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.displayName.equals(that.displayName) && this.login.equals(that.login);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.displayName.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.login.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<User> {
            public User map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String displayName = reader.readString($responseFields[2]);
                String login = reader.readString($responseFields[3]);
                return new User(__typename, id, displayName, login);
            }
        }
    }

    public static class TopPredictor {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forInt((String)"points", (String)"points", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"predictedAt", (String)"predictedAt", null, (boolean)false, (ScalarType)CustomType.TIME, Collections.emptyList()), ResponseField.forCustomType((String)"updatedAt", (String)"updatedAt", null, (boolean)false, (ScalarType)CustomType.TIME, Collections.emptyList()), ResponseField.forObject((String)"user", (String)"user", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        final int points;
        @NotNull
        final Object predictedAt;
        @NotNull
        final Object updatedAt;
        @Nullable
        final User user;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public TopPredictor(@NotNull String __typename, @NotNull String id, int points, @NotNull Object predictedAt, @NotNull Object updatedAt, @Nullable User user) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.points = points;
            this.predictedAt = Utils.checkNotNull((Object)predictedAt, (Object)"predictedAt == null");
            this.updatedAt = Utils.checkNotNull((Object)updatedAt, (Object)"updatedAt == null");
            this.user = user;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        public int points() {
            return this.points;
        }

        @NotNull
        public Object predictedAt() {
            return this.predictedAt;
        }

        @NotNull
        public Object updatedAt() {
            return this.updatedAt;
        }

        @Nullable
        public User user() {
            return this.user;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeInt($responseFields[2], Integer.valueOf(points));
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[3], predictedAt);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[4], updatedAt);
                    writer.writeObject($responseFields[5], user != null ? user.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "TopPredictor{__typename=" + this.__typename + ", id=" + this.id + ", points=" + this.points + ", predictedAt=" + this.predictedAt + ", updatedAt=" + this.updatedAt + ", user=" + this.user + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TopPredictor) {
                TopPredictor that = (TopPredictor)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.points == that.points && this.predictedAt.equals(that.predictedAt) && this.updatedAt.equals(that.updatedAt) && (this.user == null ? that.user == null : this.user.equals(that.user));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.points;
                h *= 1000003;
                h ^= this.predictedAt.hashCode();
                h *= 1000003;
                h ^= this.updatedAt.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.user == null ? 0 : this.user.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<TopPredictor> {
            final User.Mapper userFieldMapper = new User.Mapper();

            public TopPredictor map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                int points = reader.readInt($responseFields[2]);
                Object predictedAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[3]);
                Object updatedAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[4]);
                User user = (User)reader.readObject($responseFields[5], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<User>(){

                    public User read(ResponseReader reader) {
                        return userFieldMapper.map(reader);
                    }
                });
                return new TopPredictor(__typename, id, points, predictedAt, updatedAt, user);
            }
        }
    }

    public static class Outcome {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"color", (String)"color", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"title", (String)"title", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"topPredictors", (String)"topPredictors", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"totalPoints", (String)"totalPoints", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"totalUsers", (String)"totalUsers", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final PredictionOutcomeColor color;
        @NotNull
        final String id;
        @NotNull
        final String title;
        @NotNull
        final List<TopPredictor> topPredictors;
        final int totalPoints;
        final int totalUsers;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Outcome(@NotNull String __typename, @NotNull PredictionOutcomeColor color, @NotNull String id, @NotNull String title, @NotNull List<TopPredictor> topPredictors, int totalPoints, int totalUsers) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.color = (PredictionOutcomeColor)((Object)Utils.checkNotNull((Object)((Object)color), (Object)"color == null"));
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.title = (String)Utils.checkNotNull((Object)title, (Object)"title == null");
            this.topPredictors = (List)Utils.checkNotNull(topPredictors, (Object)"topPredictors == null");
            this.totalPoints = totalPoints;
            this.totalUsers = totalUsers;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public PredictionOutcomeColor color() {
            return this.color;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String title() {
            return this.title;
        }

        @NotNull
        public List<TopPredictor> topPredictors() {
            return this.topPredictors;
        }

        public int totalPoints() {
            return this.totalPoints;
        }

        public int totalUsers() {
            return this.totalUsers;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], color.rawValue());
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[2], (Object)id);
                    writer.writeString($responseFields[3], title);
                    writer.writeList($responseFields[4], topPredictors, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((TopPredictor)item).marshaller());
                            }
                        }
                    });
                    writer.writeInt($responseFields[5], Integer.valueOf(totalPoints));
                    writer.writeInt($responseFields[6], Integer.valueOf(totalUsers));
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Outcome{__typename=" + this.__typename + ", color=" + (Object)((Object)this.color) + ", id=" + this.id + ", title=" + this.title + ", topPredictors=" + this.topPredictors + ", totalPoints=" + this.totalPoints + ", totalUsers=" + this.totalUsers + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Outcome) {
                Outcome that = (Outcome)o;
                return this.__typename.equals(that.__typename) && this.color.equals((Object)that.color) && this.id.equals(that.id) && this.title.equals(that.title) && this.topPredictors.equals(that.topPredictors) && this.totalPoints == that.totalPoints && this.totalUsers == that.totalUsers;
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.color.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.title.hashCode();
                h *= 1000003;
                h ^= this.topPredictors.hashCode();
                h *= 1000003;
                h ^= this.totalPoints;
                h *= 1000003;
                this.$hashCode = h ^= this.totalUsers;
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Outcome> {
            final TopPredictor.Mapper topPredictorFieldMapper = new TopPredictor.Mapper();

            public Outcome map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String colorStr = reader.readString($responseFields[1]);
                PredictionOutcomeColor color = colorStr != null ? PredictionOutcomeColor.safeValueOf(colorStr) : null;
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[2]);
                String title = reader.readString($responseFields[3]);
                List topPredictors = reader.readList($responseFields[4], (ResponseReader.ListReader)new ResponseReader.ListReader<TopPredictor>(){

                    public TopPredictor read(ResponseReader.ListItemReader listItemReader) {
                        return (TopPredictor)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<TopPredictor>(){

                            public TopPredictor read(ResponseReader reader) {
                                return topPredictorFieldMapper.map(reader);
                            }
                        });
                    }
                });
                int totalPoints = reader.readInt($responseFields[5]);
                int totalUsers = reader.readInt($responseFields[6]);
                return new Outcome(__typename, color, id, title, topPredictors, totalPoints, totalUsers);
            }
        }
    }

    public static class AsPredictionEventActor1
    implements LockedBy {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsPredictionEventActor1(@NotNull String __typename) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
        }

        @Override
        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsPredictionEventActor1{__typename=" + this.__typename + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsPredictionEventActor1) {
                AsPredictionEventActor1 that = (AsPredictionEventActor1)o;
                return this.__typename.equals(that.__typename);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.__typename.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsPredictionEventActor1> {
            public AsPredictionEventActor1 map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                return new AsPredictionEventActor1(__typename);
            }
        }
    }

    public static class AsUser1
    implements LockedBy {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String displayName;
        @NotNull
        final String login;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsUser1(@NotNull String __typename, @NotNull String id, @NotNull String displayName, @NotNull String login) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
        }

        @Override
        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], displayName);
                    writer.writeString($responseFields[3], login);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsUser1{__typename=" + this.__typename + ", id=" + this.id + ", displayName=" + this.displayName + ", login=" + this.login + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsUser1) {
                AsUser1 that = (AsUser1)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.displayName.equals(that.displayName) && this.login.equals(that.login);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.displayName.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.login.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsUser1> {
            public AsUser1 map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String displayName = reader.readString($responseFields[2]);
                String login = reader.readString($responseFields[3]);
                return new AsUser1(__typename, id, displayName, login);
            }
        }
    }

    public static interface LockedBy {
        @NotNull
        public String __typename();

        public ResponseFieldMarshaller marshaller();

        public static final class Mapper
        implements ResponseFieldMapper<LockedBy> {
            static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forFragment((String)"__typename", (String)"__typename", Arrays.asList(ResponseField.Condition.typeCondition((String[])new String[]{"User"})))};
            final AsUser1.Mapper asUser1FieldMapper = new AsUser1.Mapper();
            final AsPredictionEventActor1.Mapper asPredictionEventActor1FieldMapper = new AsPredictionEventActor1.Mapper();

            public LockedBy map(ResponseReader reader) {
                AsUser1 asUser = (AsUser1)reader.readFragment($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<AsUser1>(){

                    public AsUser1 read(ResponseReader reader) {
                        return asUser1FieldMapper.map(reader);
                    }
                });
                if (asUser != null) {
                    return asUser;
                }
                return this.asPredictionEventActor1FieldMapper.map(reader);
            }
        }
    }

    public static class AsPredictionEventActor
    implements CreatedBy {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsPredictionEventActor(@NotNull String __typename) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
        }

        @Override
        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsPredictionEventActor{__typename=" + this.__typename + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsPredictionEventActor) {
                AsPredictionEventActor that = (AsPredictionEventActor)o;
                return this.__typename.equals(that.__typename);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.__typename.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsPredictionEventActor> {
            public AsPredictionEventActor map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                return new AsPredictionEventActor(__typename);
            }
        }
    }

    public static class AsUser
    implements CreatedBy {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String displayName;
        @NotNull
        final String login;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsUser(@NotNull String __typename, @NotNull String id, @NotNull String displayName, @NotNull String login) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
        }

        @Override
        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], displayName);
                    writer.writeString($responseFields[3], login);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsUser{__typename=" + this.__typename + ", id=" + this.id + ", displayName=" + this.displayName + ", login=" + this.login + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsUser) {
                AsUser that = (AsUser)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.displayName.equals(that.displayName) && this.login.equals(that.login);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.displayName.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.login.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsUser> {
            public AsUser map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String displayName = reader.readString($responseFields[2]);
                String login = reader.readString($responseFields[3]);
                return new AsUser(__typename, id, displayName, login);
            }
        }
    }

    public static interface CreatedBy {
        @NotNull
        public String __typename();

        public ResponseFieldMarshaller marshaller();

        public static final class Mapper
        implements ResponseFieldMapper<CreatedBy> {
            static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forFragment((String)"__typename", (String)"__typename", Arrays.asList(ResponseField.Condition.typeCondition((String[])new String[]{"User"})))};
            final AsUser.Mapper asUserFieldMapper = new AsUser.Mapper();
            final AsPredictionEventActor.Mapper asPredictionEventActorFieldMapper = new AsPredictionEventActor.Mapper();

            public CreatedBy map(ResponseReader reader) {
                AsUser asUser = (AsUser)reader.readFragment($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<AsUser>(){

                    public AsUser read(ResponseReader reader) {
                        return asUserFieldMapper.map(reader);
                    }
                });
                if (asUser != null) {
                    return asUser;
                }
                return this.asPredictionEventActorFieldMapper.map(reader);
            }
        }
    }

    public static class LockedPredictionEvent {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"createdAt", (String)"createdAt", null, (boolean)false, (ScalarType)CustomType.TIME, Collections.emptyList()), ResponseField.forObject((String)"createdBy", (String)"createdBy", null, (boolean)true, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forCustomType((String)"lockedAt", (String)"lockedAt", null, (boolean)true, (ScalarType)CustomType.TIME, Collections.emptyList()), ResponseField.forObject((String)"lockedBy", (String)"lockedBy", null, (boolean)true, Collections.emptyList()), ResponseField.forList((String)"outcomes", (String)"outcomes", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"predictionWindowSeconds", (String)"predictionWindowSeconds", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"status", (String)"status", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"title", (String)"title", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final Object createdAt;
        @Nullable
        final CreatedBy createdBy;
        @NotNull
        final String id;
        @Nullable
        final Object lockedAt;
        @Nullable
        final LockedBy lockedBy;
        @NotNull
        final List<Outcome> outcomes;
        final int predictionWindowSeconds;
        @NotNull
        final PredictionEventStatus status;
        @NotNull
        final String title;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public LockedPredictionEvent(@NotNull String __typename, @NotNull Object createdAt, @Nullable CreatedBy createdBy, @NotNull String id, @Nullable Object lockedAt, @Nullable LockedBy lockedBy, @NotNull List<Outcome> outcomes, int predictionWindowSeconds, @NotNull PredictionEventStatus status, @NotNull String title) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.createdAt = Utils.checkNotNull((Object)createdAt, (Object)"createdAt == null");
            this.createdBy = createdBy;
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.lockedAt = lockedAt;
            this.lockedBy = lockedBy;
            this.outcomes = (List)Utils.checkNotNull(outcomes, (Object)"outcomes == null");
            this.predictionWindowSeconds = predictionWindowSeconds;
            this.status = (PredictionEventStatus)((Object)Utils.checkNotNull((Object)((Object)status), (Object)"status == null"));
            this.title = (String)Utils.checkNotNull((Object)title, (Object)"title == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public Object createdAt() {
            return this.createdAt;
        }

        @Nullable
        public CreatedBy createdBy() {
            return this.createdBy;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @Nullable
        public Object lockedAt() {
            return this.lockedAt;
        }

        @Nullable
        public LockedBy lockedBy() {
            return this.lockedBy;
        }

        @NotNull
        public List<Outcome> outcomes() {
            return this.outcomes;
        }

        public int predictionWindowSeconds() {
            return this.predictionWindowSeconds;
        }

        @NotNull
        public PredictionEventStatus status() {
            return this.status;
        }

        @NotNull
        public String title() {
            return this.title;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], createdAt);
                    writer.writeObject($responseFields[2], createdBy != null ? createdBy.marshaller() : null);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[3], (Object)id);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[4], lockedAt);
                    writer.writeObject($responseFields[5], lockedBy != null ? lockedBy.marshaller() : null);
                    writer.writeList($responseFields[6], outcomes, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Outcome)item).marshaller());
                            }
                        }
                    });
                    writer.writeInt($responseFields[7], Integer.valueOf(predictionWindowSeconds));
                    writer.writeString($responseFields[8], status.rawValue());
                    writer.writeString($responseFields[9], title);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "LockedPredictionEvent{__typename=" + this.__typename + ", createdAt=" + this.createdAt + ", createdBy=" + this.createdBy + ", id=" + this.id + ", lockedAt=" + this.lockedAt + ", lockedBy=" + this.lockedBy + ", outcomes=" + this.outcomes + ", predictionWindowSeconds=" + this.predictionWindowSeconds + ", status=" + (Object)((Object)this.status) + ", title=" + this.title + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof LockedPredictionEvent) {
                LockedPredictionEvent that = (LockedPredictionEvent)o;
                return this.__typename.equals(that.__typename) && this.createdAt.equals(that.createdAt) && (this.createdBy == null ? that.createdBy == null : this.createdBy.equals(that.createdBy)) && this.id.equals(that.id) && (this.lockedAt == null ? that.lockedAt == null : this.lockedAt.equals(that.lockedAt)) && (this.lockedBy == null ? that.lockedBy == null : this.lockedBy.equals(that.lockedBy)) && this.outcomes.equals(that.outcomes) && this.predictionWindowSeconds == that.predictionWindowSeconds && this.status.equals((Object)that.status) && this.title.equals(that.title);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.createdAt.hashCode();
                h *= 1000003;
                h ^= this.createdBy == null ? 0 : this.createdBy.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.lockedAt == null ? 0 : this.lockedAt.hashCode();
                h *= 1000003;
                h ^= this.lockedBy == null ? 0 : this.lockedBy.hashCode();
                h *= 1000003;
                h ^= this.outcomes.hashCode();
                h *= 1000003;
                h ^= this.predictionWindowSeconds;
                h *= 1000003;
                h ^= this.status.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.title.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<LockedPredictionEvent> {
            final CreatedBy.Mapper createdByFieldMapper = new CreatedBy.Mapper();
            final LockedBy.Mapper lockedByFieldMapper = new LockedBy.Mapper();
            final Outcome.Mapper outcomeFieldMapper = new Outcome.Mapper();

            public LockedPredictionEvent map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Object createdAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                CreatedBy createdBy = (CreatedBy)reader.readObject($responseFields[2], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<CreatedBy>(){

                    public CreatedBy read(ResponseReader reader) {
                        return createdByFieldMapper.map(reader);
                    }
                });
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[3]);
                Object lockedAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[4]);
                LockedBy lockedBy = (LockedBy)reader.readObject($responseFields[5], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<LockedBy>(){

                    public LockedBy read(ResponseReader reader) {
                        return lockedByFieldMapper.map(reader);
                    }
                });
                List outcomes = reader.readList($responseFields[6], (ResponseReader.ListReader)new ResponseReader.ListReader<Outcome>(){

                    public Outcome read(ResponseReader.ListItemReader listItemReader) {
                        return (Outcome)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Outcome>(){

                            public Outcome read(ResponseReader reader) {
                                return outcomeFieldMapper.map(reader);
                            }
                        });
                    }
                });
                int predictionWindowSeconds = reader.readInt($responseFields[7]);
                String statusStr = reader.readString($responseFields[8]);
                PredictionEventStatus status = statusStr != null ? PredictionEventStatus.safeValueOf(statusStr) : null;
                String title = reader.readString($responseFields[9]);
                return new LockedPredictionEvent(__typename, createdAt, createdBy, id, lockedAt, lockedBy, outcomes, predictionWindowSeconds, status, title);
            }
        }
    }

    public static class Channel {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"lockedPredictionEvents", (String)"lockedPredictionEvents", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final List<LockedPredictionEvent> lockedPredictionEvents;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Channel(@NotNull String __typename, @Nullable List<LockedPredictionEvent> lockedPredictionEvents) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.lockedPredictionEvents = lockedPredictionEvents;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public List<LockedPredictionEvent> lockedPredictionEvents() {
            return this.lockedPredictionEvents;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], lockedPredictionEvents, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((LockedPredictionEvent)item).marshaller());
                            }
                        }
                    });
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Channel{__typename=" + this.__typename + ", lockedPredictionEvents=" + this.lockedPredictionEvents + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Channel) {
                Channel that = (Channel)o;
                return this.__typename.equals(that.__typename) && (this.lockedPredictionEvents == null ? that.lockedPredictionEvents == null : this.lockedPredictionEvents.equals(that.lockedPredictionEvents));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.lockedPredictionEvents == null ? 0 : this.lockedPredictionEvents.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Channel> {
            final LockedPredictionEvent.Mapper lockedPredictionEventFieldMapper = new LockedPredictionEvent.Mapper();

            public Channel map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List lockedPredictionEvents = reader.readList($responseFields[1], (ResponseReader.ListReader)new ResponseReader.ListReader<LockedPredictionEvent>(){

                    public LockedPredictionEvent read(ResponseReader.ListItemReader listItemReader) {
                        return (LockedPredictionEvent)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<LockedPredictionEvent>(){

                            public LockedPredictionEvent read(ResponseReader reader) {
                                return lockedPredictionEventFieldMapper.map(reader);
                            }
                        });
                    }
                });
                return new Channel(__typename, lockedPredictionEvents);
            }
        }
    }
}

