/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql.internal;

import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.InputFieldMarshaller;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.OperationRequestBodyComposer;
import com.apollographql.apollo.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.ResponseReader;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.github.twitch4j.graphql.internal.type.CustomType;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FetchModsQuery
implements Query<Data, Data, Variables> {
    public static final String OPERATION_ID = "e7bbf8e03401fdd68293eca6018e5f79566dca9a194d8fbc96b30df1d167099a";
    public static final String QUERY_DOCUMENT = QueryDocumentMinifier.minify((String)"query fetchMods($channelLogin: String!, $first: Int = 10, $after: Cursor) {\n  user(login: $channelLogin) {\n    __typename\n    id\n    mods(first: $first, after: $after) {\n      __typename\n      edges {\n        __typename\n        cursor\n        grantedAt\n        node {\n          __typename\n          id\n          displayName\n          login\n        }\n      }\n      pageInfo {\n        __typename\n        hasNextPage\n      }\n    }\n  }\n}");
    public static final OperationName OPERATION_NAME = new OperationName(){

        public String name() {
            return "fetchMods";
        }
    };
    private final Variables variables;

    public FetchModsQuery(@NotNull String channelLogin, @NotNull Input<Integer> first, @NotNull Input<Object> after) {
        Utils.checkNotNull((Object)channelLogin, (Object)"channelLogin == null");
        Utils.checkNotNull(first, (Object)"first == null");
        Utils.checkNotNull(after, (Object)"after == null");
        this.variables = new Variables(channelLogin, first, after);
    }

    public String operationId() {
        return OPERATION_ID;
    }

    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    public Data wrapData(Data data) {
        return data;
    }

    public Variables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public OperationName name() {
        return OPERATION_NAME;
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return SimpleOperationResponseParser.parse((BufferedSource)source, (Operation)this, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return this.parse((BufferedSource)new Buffer().write(byteString), scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source) throws IOException {
        return this.parse(source, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString) throws IOException {
        return this.parse(byteString, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(@NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public ByteString composeRequestBody() {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(boolean autoPersistQueries, boolean withQueryDocument, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)autoPersistQueries, (boolean)withQueryDocument, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    public static final class Variables
    extends Operation.Variables {
        @NotNull
        private final String channelLogin;
        private final Input<Integer> first;
        private final Input<Object> after;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(@NotNull String channelLogin, Input<Integer> first, Input<Object> after) {
            this.channelLogin = channelLogin;
            this.first = first;
            this.after = after;
            this.valueMap.put("channelLogin", channelLogin);
            if (first.defined) {
                this.valueMap.put("first", first.value);
            }
            if (after.defined) {
                this.valueMap.put("after", after.value);
            }
        }

        @NotNull
        public String channelLogin() {
            return this.channelLogin;
        }

        public Input<Integer> first() {
            return this.first;
        }

        public Input<Object> after() {
            return this.after;
        }

        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                public void marshal(InputFieldWriter writer) throws IOException {
                    writer.writeString("channelLogin", channelLogin);
                    if (((Variables)this).first.defined) {
                        writer.writeInt("first", (Integer)((Variables)this).first.value);
                    }
                    if (((Variables)this).after.defined) {
                        writer.writeCustom("after", (ScalarType)CustomType.CURSOR, ((Variables)this).after.value != null ? ((Variables)this).after.value : null);
                    }
                }
            };
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject((String)"user", (String)"user", (Map)new UnmodifiableMapBuilder(1).put((Object)"login", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"channelLogin").build()).build(), (boolean)true, Collections.emptyList())};
        @Nullable
        final User user;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@Nullable User user) {
            this.user = user;
        }

        @Nullable
        public User user() {
            return this.user;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], user != null ? user.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{user=" + this.user + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.user == null ? that.user == null : this.user.equals(that.user);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.user == null ? 0 : this.user.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final User.Mapper userFieldMapper = new User.Mapper();

            public Data map(ResponseReader reader) {
                User user = (User)reader.readObject($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<User>(){

                    public User read(ResponseReader reader) {
                        return userFieldMapper.map(reader);
                    }
                });
                return new Data(user);
            }
        }
    }

    public static final class Builder {
        @NotNull
        private String channelLogin;
        private Input<Integer> first = Input.absent();
        private Input<Object> after = Input.absent();

        Builder() {
        }

        public Builder channelLogin(@NotNull String channelLogin) {
            this.channelLogin = channelLogin;
            return this;
        }

        public Builder first(@Nullable Integer first) {
            this.first = Input.fromNullable((Object)first);
            return this;
        }

        public Builder after(@Nullable Object after) {
            this.after = Input.fromNullable((Object)after);
            return this;
        }

        public Builder firstInput(@NotNull Input<Integer> first) {
            this.first = (Input)Utils.checkNotNull(first, (Object)"first == null");
            return this;
        }

        public Builder afterInput(@NotNull Input<Object> after) {
            this.after = (Input)Utils.checkNotNull(after, (Object)"after == null");
            return this;
        }

        public FetchModsQuery build() {
            Utils.checkNotNull((Object)this.channelLogin, (Object)"channelLogin == null");
            return new FetchModsQuery(this.channelLogin, this.first, this.after);
        }
    }

    public static class PageInfo {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forBoolean((String)"hasNextPage", (String)"hasNextPage", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        final boolean hasNextPage;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public PageInfo(@NotNull String __typename, boolean hasNextPage) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.hasNextPage = hasNextPage;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        public boolean hasNextPage() {
            return this.hasNextPage;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeBoolean($responseFields[1], Boolean.valueOf(hasNextPage));
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "PageInfo{__typename=" + this.__typename + ", hasNextPage=" + this.hasNextPage + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PageInfo) {
                PageInfo that = (PageInfo)o;
                return this.__typename.equals(that.__typename) && this.hasNextPage == that.hasNextPage;
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= Boolean.valueOf(this.hasNextPage).hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<PageInfo> {
            public PageInfo map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                boolean hasNextPage = reader.readBoolean($responseFields[1]);
                return new PageInfo(__typename, hasNextPage);
            }
        }
    }

    public static class Node {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String displayName;
        @NotNull
        final String login;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Node(@NotNull String __typename, @NotNull String id, @NotNull String displayName, @NotNull String login) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], displayName);
                    writer.writeString($responseFields[3], login);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Node{__typename=" + this.__typename + ", id=" + this.id + ", displayName=" + this.displayName + ", login=" + this.login + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Node) {
                Node that = (Node)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.displayName.equals(that.displayName) && this.login.equals(that.login);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.displayName.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.login.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Node> {
            public Node map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String displayName = reader.readString($responseFields[2]);
                String login = reader.readString($responseFields[3]);
                return new Node(__typename, id, displayName, login);
            }
        }
    }

    public static class Edge {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"cursor", (String)"cursor", null, (boolean)false, (ScalarType)CustomType.CURSOR, Collections.emptyList()), ResponseField.forCustomType((String)"grantedAt", (String)"grantedAt", null, (boolean)false, (ScalarType)CustomType.TIME, Collections.emptyList()), ResponseField.forObject((String)"node", (String)"node", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final Object cursor;
        @NotNull
        final Object grantedAt;
        @NotNull
        final Node node;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Edge(@NotNull String __typename, @NotNull Object cursor, @NotNull Object grantedAt, @NotNull Node node) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.cursor = Utils.checkNotNull((Object)cursor, (Object)"cursor == null");
            this.grantedAt = Utils.checkNotNull((Object)grantedAt, (Object)"grantedAt == null");
            this.node = (Node)Utils.checkNotNull((Object)node, (Object)"node == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public Object cursor() {
            return this.cursor;
        }

        @NotNull
        public Object grantedAt() {
            return this.grantedAt;
        }

        @NotNull
        public Node node() {
            return this.node;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], cursor);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[2], grantedAt);
                    writer.writeObject($responseFields[3], node.marshaller());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Edge{__typename=" + this.__typename + ", cursor=" + this.cursor + ", grantedAt=" + this.grantedAt + ", node=" + this.node + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Edge) {
                Edge that = (Edge)o;
                return this.__typename.equals(that.__typename) && this.cursor.equals(that.cursor) && this.grantedAt.equals(that.grantedAt) && this.node.equals(that.node);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.cursor.hashCode();
                h *= 1000003;
                h ^= this.grantedAt.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.node.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Edge> {
            final Node.Mapper nodeFieldMapper = new Node.Mapper();

            public Edge map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Object cursor = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                Object grantedAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[2]);
                Node node = (Node)reader.readObject($responseFields[3], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Node>(){

                    public Node read(ResponseReader reader) {
                        return nodeFieldMapper.map(reader);
                    }
                });
                return new Edge(__typename, cursor, grantedAt, node);
            }
        }
    }

    public static class Mods {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"edges", (String)"edges", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"pageInfo", (String)"pageInfo", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final List<Edge> edges;
        @NotNull
        final PageInfo pageInfo;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Mods(@NotNull String __typename, @NotNull List<Edge> edges, @NotNull PageInfo pageInfo) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.edges = (List)Utils.checkNotNull(edges, (Object)"edges == null");
            this.pageInfo = (PageInfo)Utils.checkNotNull((Object)pageInfo, (Object)"pageInfo == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public List<Edge> edges() {
            return this.edges;
        }

        @NotNull
        public PageInfo pageInfo() {
            return this.pageInfo;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], edges, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Edge)item).marshaller());
                            }
                        }
                    });
                    writer.writeObject($responseFields[2], pageInfo.marshaller());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Mods{__typename=" + this.__typename + ", edges=" + this.edges + ", pageInfo=" + this.pageInfo + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Mods) {
                Mods that = (Mods)o;
                return this.__typename.equals(that.__typename) && this.edges.equals(that.edges) && this.pageInfo.equals(that.pageInfo);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.edges.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.pageInfo.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Mods> {
            final Edge.Mapper edgeFieldMapper = new Edge.Mapper();
            final PageInfo.Mapper pageInfoFieldMapper = new PageInfo.Mapper();

            public Mods map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List edges = reader.readList($responseFields[1], (ResponseReader.ListReader)new ResponseReader.ListReader<Edge>(){

                    public Edge read(ResponseReader.ListItemReader listItemReader) {
                        return (Edge)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Edge>(){

                            public Edge read(ResponseReader reader) {
                                return edgeFieldMapper.map(reader);
                            }
                        });
                    }
                });
                PageInfo pageInfo = (PageInfo)reader.readObject($responseFields[2], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<PageInfo>(){

                    public PageInfo read(ResponseReader reader) {
                        return pageInfoFieldMapper.map(reader);
                    }
                });
                return new Mods(__typename, edges, pageInfo);
            }
        }
    }

    public static class User {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forObject((String)"mods", (String)"mods", (Map)new UnmodifiableMapBuilder(2).put((Object)"first", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"first").build()).put((Object)"after", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"after").build()).build(), (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @Nullable
        final Mods mods;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public User(@NotNull String __typename, @NotNull String id, @Nullable Mods mods) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.mods = mods;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @Nullable
        public Mods mods() {
            return this.mods;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeObject($responseFields[2], mods != null ? mods.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "User{__typename=" + this.__typename + ", id=" + this.id + ", mods=" + this.mods + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof User) {
                User that = (User)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && (this.mods == null ? that.mods == null : this.mods.equals(that.mods));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.mods == null ? 0 : this.mods.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<User> {
            final Mods.Mapper modsFieldMapper = new Mods.Mapper();

            public User map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                Mods mods = (Mods)reader.readObject($responseFields[2], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Mods>(){

                    public Mods read(ResponseReader reader) {
                        return modsFieldMapper.map(reader);
                    }
                });
                return new User(__typename, id, mods);
            }
        }
    }
}

