/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql.command;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.Query;
import com.github.twitch4j.graphql.command.BaseCommand;
import com.github.twitch4j.graphql.internal.FetchUnbanRequestsQuery;
import com.github.twitch4j.graphql.internal.type.UnbanRequestStatus;
import com.github.twitch4j.graphql.internal.type.UnbanRequestsSortOrder;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class CommandFetchUnbanRequests
extends BaseCommand<FetchUnbanRequestsQuery.Data> {
    private final String channelLogin;
    private final String cursor;
    private final Integer limit;
    private final UnbanRequestsSortOrder order;
    private final UnbanRequestStatus status;
    private final String userId;

    public CommandFetchUnbanRequests(@NonNull ApolloClient apolloClient, @NonNull String channelLogin, @Nullable String cursor, @Nullable Integer limit, @Nullable UnbanRequestsSortOrder order, @Nullable UnbanRequestStatus status, @Nullable String userId) {
        super(apolloClient);
        if (apolloClient == null) {
            throw new NullPointerException("apolloClient is marked non-null but is null");
        }
        if (channelLogin == null) {
            throw new NullPointerException("channelLogin is marked non-null but is null");
        }
        this.channelLogin = channelLogin;
        this.cursor = cursor;
        this.limit = limit;
        this.order = order == null ? UnbanRequestsSortOrder.NEWEST : order;
        this.status = status == null ? UnbanRequestStatus.PENDING : status;
        this.userId = userId;
    }

    @Override
    protected ApolloCall<FetchUnbanRequestsQuery.Data> getGraphQLCall() {
        return this.apolloClient.query((Query)FetchUnbanRequestsQuery.builder().channelLogin(this.channelLogin).after(this.cursor).first(this.limit).order(this.order).status(this.status).userId(this.userId).build());
    }
}

