/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.extensions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.config.Twitch4JGlobal;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.extensions.TwitchExtensions;
import com.github.twitch4j.extensions.compat.TwitchExtensionsCompatibilityLayer;
import com.github.twitch4j.extensions.util.TwitchExtensionsClientIdInterceptor;
import com.github.twitch4j.extensions.util.TwitchExtensionsErrorDecoder;
import com.netflix.config.ConfigurationManager;
import feign.Client;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.hystrix.HystrixFeign;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
public class TwitchExtensionsBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwitchExtensionsBuilder.class);
    private String baseUrl = "https://api.twitch.tv/extensions";
    private String clientId = Twitch4JGlobal.clientId;
    private String clientSecret = Twitch4JGlobal.clientSecret;
    private String userAgent = Twitch4JGlobal.userAgent;
    private long timeout = 5000L;
    private int requestQueueSize = -1;
    private Logger.Level logLevel = Logger.Level.NONE;
    private ProxyConfig proxyConfig = null;
    private boolean helixForwarding = true;

    @Deprecated
    public TwitchExtensions build() {
        log.debug("Extensions: Initializing Module ...");
        if (this.helixForwarding) {
            return TwitchExtensionsCompatibilityLayer.builder().clientId(this.clientId).clientSecret(this.clientSecret).userAgent(this.userAgent).timeout(this.timeout).requestQueueSize(this.requestQueueSize).logLevel(this.logLevel).proxyConfig(this.proxyConfig).build();
        }
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.isolation.thread.timeoutInMilliseconds", (Object)this.timeout);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.requestCache.enabled", (Object)false);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.maxQueueSize", (Object)this.getRequestQueueSize());
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.queueSizeRejectionThreshold", (Object)this.getRequestQueueSize());
        if (this.logLevel == Logger.Level.HEADERS || this.logLevel == Logger.Level.FULL) {
            log.warn("Extensions: The current feign loglevel will print sensitive information including your access token, please don't share this log!");
        }
        ObjectMapper mapper = TypeConvert.getObjectMapper();
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (this.proxyConfig != null) {
            this.proxyConfig.apply(clientBuilder);
        }
        return (TwitchExtensions)HystrixFeign.builder().client((Client)new OkHttpClient(clientBuilder.build())).encoder((Encoder)new JacksonEncoder(mapper)).decoder((Decoder)new JacksonDecoder(mapper)).logger((feign.Logger)new Slf4jLogger()).logLevel(this.logLevel).errorDecoder((ErrorDecoder)new TwitchExtensionsErrorDecoder(mapper, (Decoder)new JacksonDecoder())).requestInterceptor((RequestInterceptor)new TwitchExtensionsClientIdInterceptor(this)).options(new Request.Options(this.timeout / 3L, TimeUnit.MILLISECONDS, this.timeout, TimeUnit.MILLISECONDS, true)).retryer((Retryer)new Retryer.Default(500L, this.timeout, 2)).target(TwitchExtensions.class, this.baseUrl);
    }

    @Deprecated
    public static TwitchExtensionsBuilder builder() {
        return new TwitchExtensionsBuilder();
    }

    @Generated
    private TwitchExtensionsBuilder() {
    }

    @Generated
    private TwitchExtensionsBuilder(String baseUrl, String clientId, String clientSecret, String userAgent, long timeout, int requestQueueSize, Logger.Level logLevel, ProxyConfig proxyConfig, boolean helixForwarding) {
        this.baseUrl = baseUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.userAgent = userAgent;
        this.timeout = timeout;
        this.requestQueueSize = requestQueueSize;
        this.logLevel = logLevel;
        this.proxyConfig = proxyConfig;
        this.helixForwarding = helixForwarding;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public long getTimeout() {
        return this.timeout;
    }

    @Generated
    public int getRequestQueueSize() {
        return this.requestQueueSize;
    }

    @Generated
    public Logger.Level getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    @Generated
    public boolean isHelixForwarding() {
        return this.helixForwarding;
    }

    @Generated
    public TwitchExtensionsBuilder withBaseUrl(String baseUrl) {
        return this.baseUrl == baseUrl ? this : new TwitchExtensionsBuilder(baseUrl, this.clientId, this.clientSecret, this.userAgent, this.timeout, this.requestQueueSize, this.logLevel, this.proxyConfig, this.helixForwarding);
    }

    @Generated
    public TwitchExtensionsBuilder withClientId(String clientId) {
        return this.clientId == clientId ? this : new TwitchExtensionsBuilder(this.baseUrl, clientId, this.clientSecret, this.userAgent, this.timeout, this.requestQueueSize, this.logLevel, this.proxyConfig, this.helixForwarding);
    }

    @Generated
    public TwitchExtensionsBuilder withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new TwitchExtensionsBuilder(this.baseUrl, this.clientId, clientSecret, this.userAgent, this.timeout, this.requestQueueSize, this.logLevel, this.proxyConfig, this.helixForwarding);
    }

    @Generated
    public TwitchExtensionsBuilder withUserAgent(String userAgent) {
        return this.userAgent == userAgent ? this : new TwitchExtensionsBuilder(this.baseUrl, this.clientId, this.clientSecret, userAgent, this.timeout, this.requestQueueSize, this.logLevel, this.proxyConfig, this.helixForwarding);
    }

    @Generated
    public TwitchExtensionsBuilder withTimeout(long timeout) {
        return this.timeout == timeout ? this : new TwitchExtensionsBuilder(this.baseUrl, this.clientId, this.clientSecret, this.userAgent, timeout, this.requestQueueSize, this.logLevel, this.proxyConfig, this.helixForwarding);
    }

    @Generated
    public TwitchExtensionsBuilder withRequestQueueSize(int requestQueueSize) {
        return this.requestQueueSize == requestQueueSize ? this : new TwitchExtensionsBuilder(this.baseUrl, this.clientId, this.clientSecret, this.userAgent, this.timeout, requestQueueSize, this.logLevel, this.proxyConfig, this.helixForwarding);
    }

    @Generated
    public TwitchExtensionsBuilder withLogLevel(Logger.Level logLevel) {
        return this.logLevel == logLevel ? this : new TwitchExtensionsBuilder(this.baseUrl, this.clientId, this.clientSecret, this.userAgent, this.timeout, this.requestQueueSize, logLevel, this.proxyConfig, this.helixForwarding);
    }

    @Generated
    public TwitchExtensionsBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchExtensionsBuilder(this.baseUrl, this.clientId, this.clientSecret, this.userAgent, this.timeout, this.requestQueueSize, this.logLevel, proxyConfig, this.helixForwarding);
    }

    @Generated
    public TwitchExtensionsBuilder withHelixForwarding(boolean helixForwarding) {
        return this.helixForwarding == helixForwarding ? this : new TwitchExtensionsBuilder(this.baseUrl, this.clientId, this.clientSecret, this.userAgent, this.timeout, this.requestQueueSize, this.logLevel, this.proxyConfig, helixForwarding);
    }
}

