/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.client.websocket;

import com.github.twitch4j.client.websocket.domain.WebsocketConnectionState;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.util.ExponentialBackoffStrategy;
import com.github.twitch4j.util.IBackoffStrategy;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebsocketConnectionConfig {
    private String baseUrl;
    private int wsPingPeriod = 0;
    private int connectionTimeout = 60000;
    private int socketTimeout = 30000;
    private int closeDelay = 1000;
    private Map<String, String> headers = null;
    private ScheduledExecutorService taskExecutor = new ScheduledThreadPoolExecutor(2);
    private IBackoffStrategy backoffStrategy = ExponentialBackoffStrategy.builder().immediateFirst(false).baseMillis(Duration.ofSeconds(1L).toMillis()).jitter(true).multiplier(2.0).maximumBackoff(Duration.ofMinutes(5L).toMillis()).build();
    private BiConsumer<WebsocketConnectionState, WebsocketConnectionState> onStateChanged = (oldState, newState) -> {};
    private Runnable onPreConnect = () -> {};
    private Runnable onPostConnect = () -> {};
    private Runnable onConnected = () -> {};
    private Consumer<String> onTextMessage = text -> {};
    private Runnable onDisconnecting = () -> {};
    private Runnable onPreDisconnect = () -> {};
    private Runnable onPostDisconnect = () -> {};
    private BiConsumer<@NotNull Integer, @Nullable String> onCloseFrame = (code, reason) -> {};
    private ProxyConfig proxyConfig;

    public static WebsocketConnectionConfig process(Consumer<WebsocketConnectionConfig> spec) {
        WebsocketConnectionConfig data = new WebsocketConnectionConfig();
        spec.accept(data);
        data.validate();
        return data;
    }

    public void validate() {
        Objects.requireNonNull(this.baseUrl, "baseUrl may not be null!");
        if (this.wsPingPeriod < 0) {
            throw new RuntimeException("wsPingPeriod must be 0 or greater, set to 0 to disable!");
        }
        if (this.connectionTimeout < 0) {
            throw new RuntimeException("connectionTimeout must be 0 or greater, set to 0 to disable!");
        }
        if (this.socketTimeout < 0) {
            throw new RuntimeException("socketTimeout must be 0 or greater, set to 0 to disable!");
        }
        if (this.closeDelay < 0) {
            throw new RuntimeException("closeDelay must be 0 or greater!");
        }
        Objects.requireNonNull(this.taskExecutor, "taskExecutor may not be null!");
        Objects.requireNonNull(this.backoffStrategy, "backoffStrategy may not be null!");
        Objects.requireNonNull(this.onStateChanged, "onStateChanged may not be null!");
        Objects.requireNonNull(this.onPreConnect, "onPreConnect may not be null!");
        Objects.requireNonNull(this.onPostConnect, "onPostConnect may not be null!");
        Objects.requireNonNull(this.onConnected, "onConnected may not be null!");
        Objects.requireNonNull(this.onTextMessage, "onTextMessage may not be null!");
        Objects.requireNonNull(this.onTextMessage, "onTextMessage may not be null!");
        Objects.requireNonNull(this.onDisconnecting, "onDisconnecting may not be null!");
        Objects.requireNonNull(this.onPreDisconnect, "onPreDisconnect may not be null!");
        Objects.requireNonNull(this.onPostDisconnect, "onPostDisconnect may not be null!");
        Objects.requireNonNull(this.onCloseFrame, "onCloseFrame may not be null!");
    }

    @Generated
    public WebsocketConnectionConfig baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig wsPingPeriod(int wsPingPeriod) {
        this.wsPingPeriod = wsPingPeriod;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig connectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig closeDelay(int closeDelay) {
        this.closeDelay = closeDelay;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig taskExecutor(ScheduledExecutorService taskExecutor) {
        this.taskExecutor = taskExecutor;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig backoffStrategy(IBackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig onStateChanged(BiConsumer<WebsocketConnectionState, WebsocketConnectionState> onStateChanged) {
        this.onStateChanged = onStateChanged;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig onPreConnect(Runnable onPreConnect) {
        this.onPreConnect = onPreConnect;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig onPostConnect(Runnable onPostConnect) {
        this.onPostConnect = onPostConnect;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig onConnected(Runnable onConnected) {
        this.onConnected = onConnected;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig onTextMessage(Consumer<String> onTextMessage) {
        this.onTextMessage = onTextMessage;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig onDisconnecting(Runnable onDisconnecting) {
        this.onDisconnecting = onDisconnecting;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig onPreDisconnect(Runnable onPreDisconnect) {
        this.onPreDisconnect = onPreDisconnect;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig onPostDisconnect(Runnable onPostDisconnect) {
        this.onPostDisconnect = onPostDisconnect;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig onCloseFrame(BiConsumer<@NotNull Integer, @Nullable String> onCloseFrame) {
        this.onCloseFrame = onCloseFrame;
        return this;
    }

    @Generated
    public WebsocketConnectionConfig proxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        return this;
    }

    @Generated
    public String baseUrl() {
        return this.baseUrl;
    }

    @Generated
    public int wsPingPeriod() {
        return this.wsPingPeriod;
    }

    @Generated
    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public int socketTimeout() {
        return this.socketTimeout;
    }

    @Generated
    public int closeDelay() {
        return this.closeDelay;
    }

    @Generated
    public Map<String, String> headers() {
        return this.headers;
    }

    @Generated
    public ScheduledExecutorService taskExecutor() {
        return this.taskExecutor;
    }

    @Generated
    public IBackoffStrategy backoffStrategy() {
        return this.backoffStrategy;
    }

    @Generated
    public BiConsumer<WebsocketConnectionState, WebsocketConnectionState> onStateChanged() {
        return this.onStateChanged;
    }

    @Generated
    public Runnable onPreConnect() {
        return this.onPreConnect;
    }

    @Generated
    public Runnable onPostConnect() {
        return this.onPostConnect;
    }

    @Generated
    public Runnable onConnected() {
        return this.onConnected;
    }

    @Generated
    public Consumer<String> onTextMessage() {
        return this.onTextMessage;
    }

    @Generated
    public Runnable onDisconnecting() {
        return this.onDisconnecting;
    }

    @Generated
    public Runnable onPreDisconnect() {
        return this.onPreDisconnect;
    }

    @Generated
    public Runnable onPostDisconnect() {
        return this.onPostDisconnect;
    }

    @Generated
    public BiConsumer<@NotNull Integer, @Nullable String> onCloseFrame() {
        return this.onCloseFrame;
    }

    @Generated
    public ProxyConfig proxyConfig() {
        return this.proxyConfig;
    }
}

