/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.client.websocket;

import com.github.twitch4j.client.websocket.WebsocketConnectionConfig;
import com.github.twitch4j.client.websocket.domain.WebsocketConnectionState;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketError;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketConnection
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebsocketConnection.class);
    @Generated
    private final Object $lock = new Object[0];
    protected final WebsocketConnectionConfig config;
    private volatile WebSocket webSocket;
    private final AtomicReference<WebsocketConnectionState> connectionState = new AtomicReference<WebsocketConnectionState>(WebsocketConnectionState.DISCONNECTED);
    private volatile Future<?> backoffClearer;
    private final AtomicReference<Future<?>> reconnectTask = new AtomicReference();
    protected final WebSocketFactory webSocketFactory;
    protected final WebSocketAdapter webSocketAdapter;
    protected final AtomicLong lastPing = new AtomicLong();
    protected volatile long latency = -1L;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected final CountDownLatch closeLatch = new CountDownLatch(1);

    public WebsocketConnection(Consumer<WebsocketConnectionConfig> configSpec) {
        this.config = WebsocketConnectionConfig.process(configSpec);
        this.webSocketFactory = new WebSocketFactory().setConnectionTimeout(this.config.connectionTimeout()).setSocketTimeout(this.config.socketTimeout());
        if (this.config.proxyConfig() != null) {
            this.webSocketFactory.getProxySettings().setHost(this.config.proxyConfig().getHostname()).setPort(this.config.proxyConfig().getPort().intValue()).setId(this.config.proxyConfig().getUsername()).setPassword(this.config.proxyConfig().getPassword() == null ? null : String.valueOf(this.config.proxyConfig().getPassword()));
        }
        this.webSocketAdapter = new WebSocketAdapter(){

            public void onConnected(WebSocket ws, Map<String, List<String>> headers) {
                WebsocketConnection.this.config.onConnected().run();
                WebsocketConnection.this.setState(WebsocketConnectionState.CONNECTED);
                WebsocketConnection.this.backoffClearer = WebsocketConnection.this.config.taskExecutor().schedule(() -> {
                    if (WebsocketConnection.this.connectionState.get() == WebsocketConnectionState.CONNECTED) {
                        WebsocketConnection.this.config.backoffStrategy().reset();
                    }
                }, 30L, TimeUnit.SECONDS);
            }

            public void onTextMessage(WebSocket ws, String text) {
                WebsocketConnection.this.config.onTextMessage().accept(text);
            }

            public void onCloseFrame(WebSocket websocket, WebSocketFrame frame) {
                WebsocketConnection.this.config.onCloseFrame().accept(frame.getCloseCode(), frame.getCloseReason());
            }

            public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) {
                if (WebsocketConnection.this.connectionState.get() != WebsocketConnectionState.DISCONNECTING) {
                    long reconnectDelay;
                    WebsocketConnection.this.closeSocket();
                    WebsocketConnection.this.setState(WebsocketConnectionState.LOST);
                    log.info("Connection to WebSocket [{}] lost! Retrying soon ...", (Object)WebsocketConnection.this.config.baseUrl());
                    if (WebsocketConnection.this.backoffClearer != null) {
                        WebsocketConnection.this.backoffClearer.cancel(false);
                    }
                    if ((reconnectDelay = WebsocketConnection.this.config.backoffStrategy().get()) < 0L) {
                        log.debug("Maximum retry count for websocket reconnection attempts was hit.");
                        WebsocketConnection.this.config.backoffStrategy().reset();
                    } else {
                        Future previousReconnection = WebsocketConnection.this.reconnectTask.getAndSet(WebsocketConnection.this.config.taskExecutor().schedule(() -> {
                            WebsocketConnectionState state = (WebsocketConnectionState)((Object)((Object)WebsocketConnection.this.connectionState.get()));
                            if (state != WebsocketConnectionState.CONNECTING && state != WebsocketConnectionState.CONNECTED && !WebsocketConnection.this.closed.get()) {
                                WebsocketConnection.this.reconnect();
                            }
                        }, reconnectDelay, TimeUnit.MILLISECONDS));
                        if (previousReconnection != null) {
                            previousReconnection.cancel(false);
                        }
                    }
                } else {
                    WebsocketConnection.this.setState(WebsocketConnectionState.DISCONNECTED);
                    log.info("Disconnected from WebSocket [{}]!", (Object)WebsocketConnection.this.config.baseUrl());
                }
            }

            public void onFrameSent(WebSocket websocket, WebSocketFrame frame) {
                if (frame != null && frame.isPingFrame()) {
                    WebsocketConnection.this.lastPing.compareAndSet(0L, System.currentTimeMillis());
                }
            }

            public void onPongFrame(WebSocket websocket, WebSocketFrame frame) {
                long last = WebsocketConnection.this.lastPing.getAndSet(0L);
                if (last > 0L) {
                    WebsocketConnection.this.latency = System.currentTimeMillis() - last;
                    log.trace("T4J Websocket: Round-trip socket latency recorded at {} ms.", (Object)WebsocketConnection.this.latency);
                }
            }
        };
    }

    protected WebSocket createWebsocket() throws IOException {
        WebSocket ws = this.webSocketFactory.createSocket(this.config.baseUrl());
        ws.setMissingCloseFrameAllowed(true);
        ws.setPingInterval((long)this.config.wsPingPeriod());
        if (this.config.headers() != null) {
            this.config.headers().forEach((arg_0, arg_1) -> ((WebSocket)ws).addHeader(arg_0, arg_1));
        }
        ws.clearListeners();
        ws.addListener((WebSocketListener)this.webSocketAdapter);
        return ws;
    }

    protected void setState(WebsocketConnectionState newState) {
        WebsocketConnectionState oldState = this.connectionState.getAndSet(newState);
        if (oldState != newState) {
            this.config.onStateChanged().accept(oldState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.$lock;
        synchronized (object) {
            WebsocketConnectionState connectionState = this.connectionState.get();
            if (connectionState == WebsocketConnectionState.DISCONNECTED || connectionState == WebsocketConnectionState.RECONNECTING || connectionState == WebsocketConnectionState.LOST) {
                if (this.closed.get()) {
                    throw new IllegalStateException("WebsocketConnection was already closed!");
                }
                try {
                    this.closeSocket();
                    this.config.onPreConnect().run();
                    this.setState(WebsocketConnectionState.CONNECTING);
                    this.webSocket = this.createWebsocket();
                    this.webSocket.connect();
                    this.config.onPostConnect().run();
                }
                catch (Exception ex) {
                    long retryDelay = this.config.backoffStrategy().get();
                    if (retryDelay < 0L) {
                        log.error("failed to connect to webSocket server {} and max retries were hit.", (Object)this.config.baseUrl(), (Object)ex);
                        this.config.backoffStrategy().reset();
                        return;
                    }
                    log.error("connection to webSocket server {} failed: retrying ...", (Object)this.config.baseUrl(), (Object)ex);
                    try {
                        Thread.sleep(retryDelay);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.reconnect();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.$lock;
        synchronized (object) {
            WebsocketConnectionState connectionState;
            Future reconnector = this.reconnectTask.getAndSet(null);
            if (reconnector != null) {
                reconnector.cancel(false);
            }
            if ((connectionState = this.connectionState.get()) == WebsocketConnectionState.DISCONNECTED) {
                return;
            }
            if (connectionState == WebsocketConnectionState.CONNECTED || connectionState == WebsocketConnectionState.LOST) {
                this.config.onDisconnecting().run();
                this.setState(WebsocketConnectionState.DISCONNECTING);
            }
            this.config.onPreDisconnect().run();
            this.closeSocket();
            this.setState(WebsocketConnectionState.DISCONNECTED);
            this.config.onPostDisconnect().run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.$lock;
        synchronized (object) {
            this.setState(WebsocketConnectionState.RECONNECTING);
            this.disconnect();
            this.connect();
        }
    }

    public boolean sendText(String message) {
        WebsocketConnectionState connectionState = this.connectionState.get();
        if (connectionState != WebsocketConnectionState.CONNECTED && connectionState != WebsocketConnectionState.CONNECTING) {
            return false;
        }
        this.webSocket.sendText(message);
        return true;
    }

    public WebsocketConnectionState getConnectionState() {
        return this.connectionState.get();
    }

    @Override
    public void close() throws Exception {
        if (this.closed.getAndSet(true)) {
            return;
        }
        if (this.backoffClearer != null) {
            this.backoffClearer.cancel(false);
        }
        try {
            this.disconnect();
        }
        catch (Exception e) {
            log.warn("Exception thrown from websocket disconnect attempt", (Throwable)e);
            this.closeSocket();
        }
        finally {
            try {
                boolean completed = this.closeLatch.await((long)this.config.closeDelay() + 1000L, TimeUnit.MILLISECONDS);
                if (completed) {
                    log.trace("Underlying websocket complete close was successful");
                } else {
                    log.warn("Underlying websocket did not close within the expected delay");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        Object object = this.$lock;
        synchronized (object) {
            final WebSocket socket = this.webSocket;
            if (socket != null) {
                socket.clearListeners();
                if (this.closed.get()) {
                    socket.addListener((WebSocketListener)new WebSocketAdapter(){

                        public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) {
                            socket.clearListeners();
                            WebsocketConnection.this.closeLatch.countDown();
                        }

                        public void onSendError(WebSocket websocket, WebSocketException cause, WebSocketFrame frame) {
                            if (cause != null && cause.getError() == WebSocketError.FLUSH_ERROR) {
                                socket.clearListeners();
                                WebsocketConnection.this.closeLatch.countDown();
                            }
                        }
                    });
                }
                socket.disconnect(1000, null, (long)this.config.closeDelay());
                this.webSocket = null;
            }
            this.latency = -1L;
            this.lastPing.lazySet(0L);
        }
    }

    @Generated
    public WebsocketConnectionConfig getConfig() {
        return this.config;
    }

    @Generated
    public long getLatency() {
        return this.latency;
    }
}

