/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events.channel;

import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import com.github.twitch4j.common.util.TwitchUtils;
import java.util.Map;
import java.util.Optional;

public interface MirrorableEvent {
    public IRCMessageEvent getMessageEvent();

    default public boolean isMirrored() {
        String roomId = this.getMessageEvent().getChannelId();
        return this.getSourceChannelId().filter(otherId -> !otherId.equals(roomId)).isPresent();
    }

    default public Optional<String> getSourceChannelId() {
        return this.getMessageEvent().getTagValue("source-room-id");
    }

    default public Optional<String> getSourceMessageId() {
        return this.getMessageEvent().getTagValue("source-id");
    }

    default public Optional<Map<String, String>> getSourceBadges() {
        return this.getMessageEvent().getTagValue("source-badges").map(TwitchUtils::parseBadges);
    }

    default public Optional<Map<String, String>> getSourceBadgeInfo() {
        return this.getMessageEvent().getTagValue("source-badge-info").map(TwitchUtils::parseBadges);
    }

    default public Optional<String> getSourceNoticeType() {
        return this.getMessageEvent().getTagValue("source-msg-id");
    }
}

