/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.commands.parameter;

import com.github.theholywaffle.teamspeak3.commands.parameter.Parameter;
import java.util.ArrayList;
import java.util.List;

public class ArrayParameter
extends Parameter {
    private final int parametersPerEntry;
    private final List<Parameter> parameters;

    public ArrayParameter(int numberOfEntries) {
        this(numberOfEntries, 1);
    }

    public ArrayParameter(int numberOfEntries, int parametersPerEntry) {
        this.parametersPerEntry = parametersPerEntry;
        this.parameters = new ArrayList<Parameter>(numberOfEntries * parametersPerEntry);
    }

    public ArrayParameter add(Parameter p) {
        this.parameters.add(p);
        return this;
    }

    @Override
    public void appendTo(StringBuilder str) {
        if (this.parameters.isEmpty()) {
            return;
        }
        this.parameters.get(0).appendTo(str);
        for (int i = 1; i < this.parametersPerEntry; ++i) {
            str.append(' ');
            this.parameters.get(i).appendTo(str);
        }
        for (int offset = this.parametersPerEntry; offset < this.parameters.size(); offset += this.parametersPerEntry) {
            str.append('|');
            this.parameters.get(offset).appendTo(str);
            for (int i = 1; i < this.parametersPerEntry; ++i) {
                str.append(' ');
                this.parameters.get(offset + i).appendTo(str);
            }
        }
    }
}

