/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.commands;

import com.github.theholywaffle.teamspeak3.commands.Command;
import com.github.theholywaffle.teamspeak3.commands.CommandBuilder;
import com.github.theholywaffle.teamspeak3.commands.parameter.KeyValueParam;

public final class MessageCommands {
    private MessageCommands() {
        throw new Error("No instances");
    }

    public static Command messageAdd(String clientUId, String subject, String message) {
        if (clientUId == null || clientUId.isEmpty()) {
            throw new IllegalArgumentException("Client UId must be a non-empty string");
        }
        CommandBuilder builder = new CommandBuilder("messageadd", 3);
        builder.add(new KeyValueParam("cluid", clientUId));
        builder.add(new KeyValueParam("subject", subject));
        builder.add(new KeyValueParam("message", message));
        return builder.build();
    }

    public static Command messageDel(int messageId) {
        return new CommandBuilder("messagedel", 1).add(new KeyValueParam("msgid", messageId)).build();
    }

    public static Command messageGet(int messageId) {
        return new CommandBuilder("messageget", 1).add(new KeyValueParam("msgid", messageId)).build();
    }

    public static Command messageList() {
        return new CommandBuilder("messagelist").build();
    }

    public static Command messageUpdateFlag(int messageId, boolean read) {
        CommandBuilder builder = new CommandBuilder("messageupdateflag", 2);
        builder.add(new KeyValueParam("msgid", messageId));
        builder.add(new KeyValueParam("flag", read));
        return builder.build();
    }
}

