/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.commands;

import com.github.theholywaffle.teamspeak3.commands.Command;
import com.github.theholywaffle.teamspeak3.commands.CommandBuilder;
import com.github.theholywaffle.teamspeak3.commands.parameter.ArrayParameter;
import com.github.theholywaffle.teamspeak3.commands.parameter.KeyValueParam;

public final class FileCommands {
    private FileCommands() {
        throw new Error("No instances");
    }

    public static Command ftCreateDir(String path, int channelId, String channelPassword) {
        CommandBuilder builder = new CommandBuilder("ftcreatedir", 3);
        builder.add(new KeyValueParam("cid", channelId));
        builder.add(new KeyValueParam("cpw", channelPassword));
        builder.add(new KeyValueParam("dirname", FileCommands.prefixSlash(path)));
        return builder.build();
    }

    public static Command ftDeleteFile(int channelId, String channelPassword, String ... filePaths) {
        if (filePaths == null || filePaths.length == 0) {
            throw new IllegalArgumentException("File array cannot be null or empty");
        }
        CommandBuilder builder = new CommandBuilder("ftdeletefile", 3);
        builder.add(new KeyValueParam("cid", channelId));
        builder.add(new KeyValueParam("cpw", channelPassword));
        ArrayParameter files = new ArrayParameter(filePaths.length);
        for (String filePath : filePaths) {
            files.add(new KeyValueParam("name", FileCommands.prefixSlash(filePath)));
        }
        builder.add(files);
        return builder.build();
    }

    public static Command ftGetFileInfo(int channelId, String channelPassword, String ... filePaths) {
        if (filePaths == null || filePaths.length == 0) {
            throw new IllegalArgumentException("File array cannot be null or empty");
        }
        CommandBuilder builder = new CommandBuilder("ftgetfileinfo", 1);
        ArrayParameter files = new ArrayParameter(filePaths.length, 3);
        for (String filePath : filePaths) {
            files.add(new KeyValueParam("cid", channelId));
            files.add(new KeyValueParam("cpw", channelPassword));
            files.add(new KeyValueParam("name", FileCommands.prefixSlash(filePath)));
        }
        builder.add(files);
        return builder.build();
    }

    public static Command ftGetFileInfo(int[] channelIds, String[] channelPasswords, String[] filePaths) {
        if (channelIds == null || channelIds.length == 0) {
            throw new IllegalArgumentException("Channel ID array cannot be null or empty");
        }
        if (filePaths == null || filePaths.length == 0) {
            throw new IllegalArgumentException("File array cannot be null or empty");
        }
        if (channelIds.length != filePaths.length) {
            throw new IllegalArgumentException("Channel IDs length doesn't match file paths length");
        }
        if (channelPasswords != null && filePaths.length != channelPasswords.length) {
            throw new IllegalArgumentException("Passwords length doesn't match file paths length");
        }
        CommandBuilder builder = new CommandBuilder("ftgetfileinfo", 1);
        ArrayParameter files = new ArrayParameter(filePaths.length, 3);
        for (int i = 0; i < filePaths.length; ++i) {
            String password = channelPasswords == null ? null : channelPasswords[i];
            files.add(new KeyValueParam("cid", channelIds[i]));
            files.add(new KeyValueParam("cpw", password));
            files.add(new KeyValueParam("name", FileCommands.prefixSlash(filePaths[i])));
        }
        builder.add(files);
        return builder.build();
    }

    public static Command ftGetFileList(String directoryPath, int channelId, String channelPassword) {
        if (directoryPath == null) {
            throw new IllegalArgumentException("Directory path cannot be null");
        }
        CommandBuilder builder = new CommandBuilder("ftgetfilelist", 3);
        builder.add(new KeyValueParam("cid", channelId));
        builder.add(new KeyValueParam("cpw", channelPassword));
        String path = directoryPath;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        builder.add(new KeyValueParam("path", path));
        return builder.build();
    }

    public static Command ftInitDownload(int transferId, String path, int channelId, String channelPassword) {
        CommandBuilder builder = new CommandBuilder("ftinitdownload", 6);
        builder.add(new KeyValueParam("clientftfid", transferId));
        builder.add(new KeyValueParam("name", FileCommands.prefixSlash(path)));
        builder.add(new KeyValueParam("cid", channelId));
        builder.add(new KeyValueParam("cpw", channelPassword));
        builder.add(new KeyValueParam("seekpos", 0));
        builder.add(new KeyValueParam("proto", 0));
        return builder.build();
    }

    public static Command ftInitUpload(int transferId, String path, int channelId, String channelPassword, long size, boolean overwrite) {
        CommandBuilder builder = new CommandBuilder("ftinitupload", 8);
        builder.add(new KeyValueParam("clientftfid", transferId));
        builder.add(new KeyValueParam("name", FileCommands.prefixSlash(path)));
        builder.add(new KeyValueParam("cid", channelId));
        builder.add(new KeyValueParam("cpw", channelPassword));
        builder.add(new KeyValueParam("size", size));
        builder.add(new KeyValueParam("overwrite", overwrite));
        builder.add(new KeyValueParam("resume", 0));
        builder.add(new KeyValueParam("proto", 0));
        return builder.build();
    }

    public static Command ftList() {
        return new CommandBuilder("ftlist").build();
    }

    public static Command ftRenameFile(String oldPath, String newPath, int channelId, String channelPassword) {
        if (oldPath == null) {
            throw new IllegalArgumentException("Old file path cannot be null");
        }
        if (newPath == null) {
            throw new IllegalArgumentException("New file path cannot be null");
        }
        CommandBuilder builder = new CommandBuilder("ftrenamefile", 4);
        builder.add(new KeyValueParam("cid", channelId));
        builder.add(new KeyValueParam("cpw", channelPassword));
        builder.add(new KeyValueParam("oldname", FileCommands.prefixSlash(oldPath)));
        builder.add(new KeyValueParam("newname", FileCommands.prefixSlash(newPath)));
        return builder.build();
    }

    public static Command ftRenameFile(String oldPath, String newPath, int oldChannelId, String oldChannelPassword, int newChannelId, String newChannelPassword) {
        if (oldPath == null) {
            throw new IllegalArgumentException("Old file path cannot be null");
        }
        if (newPath == null) {
            throw new IllegalArgumentException("New file path cannot be null");
        }
        CommandBuilder builder = new CommandBuilder("ftrenamefile", 6);
        builder.add(new KeyValueParam("cid", oldChannelId));
        builder.add(new KeyValueParam("cpw", oldChannelPassword));
        builder.add(new KeyValueParam("tcid", newChannelId));
        builder.add(new KeyValueParam("tcpw", newChannelPassword));
        builder.add(new KeyValueParam("oldname", FileCommands.prefixSlash(oldPath)));
        builder.add(new KeyValueParam("newname", FileCommands.prefixSlash(newPath)));
        return builder.build();
    }

    private static String prefixSlash(String path) {
        if (path == null) {
            throw new IllegalArgumentException("File path cannot be null");
        }
        return path.startsWith("/") ? path : "/" + path;
    }
}

