/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.api.wrapper;

import com.github.theholywaffle.teamspeak3.api.CodecEncryptionMode;
import com.github.theholywaffle.teamspeak3.api.HostBannerMode;
import com.github.theholywaffle.teamspeak3.api.HostMessageMode;
import com.github.theholywaffle.teamspeak3.api.VirtualServerProperty;
import com.github.theholywaffle.teamspeak3.api.wrapper.VirtualServer;
import java.util.Date;
import java.util.Map;

public class VirtualServerInfo
extends VirtualServer {
    public VirtualServerInfo(Map<String, String> map) {
        super(map);
    }

    public int getAntifloodPointsNeededCommandBlock() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_ANTIFLOOD_POINTS_NEEDED_COMMAND_BLOCK);
    }

    public int getAntifloodPointsNeedIpBlock() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_ANTIFLOOD_POINTS_NEEDED_IP_BLOCK);
    }

    public int getAntifloodPointsTickReduce() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_ANTIFLOOD_POINTS_TICK_REDUCE);
    }

    public long getBandwidthReceivedLastMinute() {
        return this.getInt(VirtualServerProperty.CONNECTION_BANDWIDTH_RECEIVED_LAST_MINUTE_TOTAL);
    }

    public long getBandwidthReceivedLastSecond() {
        return this.getLong(VirtualServerProperty.CONNECTION_BANDWIDTH_RECEIVED_LAST_SECOND_TOTAL);
    }

    public long getBandwidthSentLastMinute() {
        return this.getLong(VirtualServerProperty.CONNECTION_BANDWIDTH_SENT_LAST_MINUTE_TOTAL);
    }

    public long getBandwidthSentLastSecond() {
        return this.getLong(VirtualServerProperty.CONNECTION_BANDWIDTH_SENT_LAST_SECOND_TOTAL);
    }

    public int getChannelsOnline() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_CHANNELSONLINE);
    }

    public CodecEncryptionMode getCodecEncryptionMode() {
        int encryptionMode = this.getInt(VirtualServerProperty.VIRTUALSERVER_CODEC_ENCRYPTION_MODE);
        for (CodecEncryptionMode m : CodecEncryptionMode.values()) {
            if (m.getIndex() != encryptionMode) continue;
            return m;
        }
        return CodecEncryptionMode.UNKNOWN;
    }

    public int getComplaintAutobanCount() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_COMPLAIN_AUTOBAN_COUNT);
    }

    public long getComplaintAutobanTime() {
        return this.getLong(VirtualServerProperty.VIRTUALSERVER_COMPLAIN_AUTOBAN_TIME);
    }

    public long getComplaintRemoveTime() {
        return this.getLong(VirtualServerProperty.VIRTUALSERVER_COMPLAIN_REMOVE_TIME);
    }

    public long getControlBytesReceived() {
        return this.getLong(VirtualServerProperty.CONNECTION_BYTES_RECEIVED_CONTROL);
    }

    public long getControlBytesSent() {
        return this.getLong(VirtualServerProperty.CONNECTION_BYTES_SENT_CONTROL);
    }

    public long getControlPacketsReceived() {
        return this.getLong(VirtualServerProperty.CONNECTION_PACKETS_RECEIVED_CONTROL);
    }

    public long getControlPacketsSent() {
        return this.getLong(VirtualServerProperty.CONNECTION_PACKETS_SENT_CONTROL);
    }

    public Date getCreatedDate() {
        return new Date(this.getLong(VirtualServerProperty.VIRTUALSERVER_CREATED) * 1000L);
    }

    public int getDefaultChannelAdminGroup() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_DEFAULT_CHANNEL_ADMIN_GROUP);
    }

    public int getDefaultChannelGroup() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_DEFAULT_CHANNEL_GROUP);
    }

    public int getDefaultServerGroup() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_DEFAULT_SERVER_GROUP);
    }

    public long getDownloadQuota() {
        return this.getLong(VirtualServerProperty.VIRTUALSERVER_DOWNLOAD_QUOTA);
    }

    public String getFileBase() {
        return this.get(VirtualServerProperty.VIRTUALSERVER_FILEBASE);
    }

    public long getFiletransferBandwidthReceived() {
        return this.getLong(VirtualServerProperty.CONNECTION_FILETRANSFER_BANDWIDTH_RECEIVED);
    }

    public long getFiletransferBandwidthSent() {
        return this.getLong(VirtualServerProperty.CONNECTION_FILETRANSFER_BANDWIDTH_SENT);
    }

    public long getFiletransferBytesReceived() {
        return this.getLong(VirtualServerProperty.CONNECTION_FILETRANSFER_BYTES_RECEIVED_TOTAL);
    }

    public long getFiletransferBytesSent() {
        return this.getLong(VirtualServerProperty.CONNECTION_FILETRANSFER_BYTES_SENT_TOTAL);
    }

    public int getHostbannerGfxInterval() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_HOSTBANNER_GFX_INTERVAL);
    }

    public String getHostbannerGfxUrl() {
        return this.get(VirtualServerProperty.VIRTUALSERVER_HOSTBANNER_GFX_URL);
    }

    public HostBannerMode getHostbannerMode() {
        int hostbannerMode = this.getInt(VirtualServerProperty.VIRTUALSERVER_HOSTBANNER_MODE);
        for (HostBannerMode m : HostBannerMode.values()) {
            if (m.getIndex() != hostbannerMode) continue;
            return m;
        }
        return HostBannerMode.UNKNOWN;
    }

    public String getHostbannerUrl() {
        return this.get(VirtualServerProperty.VIRTUALSERVER_HOSTBANNER_URL);
    }

    public String getHostbuttonGfxUrl() {
        return this.get(VirtualServerProperty.VIRTUALSERVER_HOSTBUTTON_GFX_URL);
    }

    public String getHostbuttonTooltip() {
        return this.get(VirtualServerProperty.VIRTUALSERVER_HOSTBUTTON_TOOLTIP);
    }

    public String getHostbuttonUrl() {
        return this.get(VirtualServerProperty.VIRTUALSERVER_HOSTBUTTON_URL);
    }

    public String getHostMessage() {
        return this.get(VirtualServerProperty.VIRTUALSERVER_HOSTMESSAGE);
    }

    public HostMessageMode getHostMessageMode() {
        int hostmessageMode = this.getInt(VirtualServerProperty.VIRTUALSERVER_HOSTMESSAGE_MODE);
        for (HostMessageMode m : HostMessageMode.values()) {
            if (m.getIndex() != hostmessageMode) continue;
            return m;
        }
        return HostMessageMode.UNKNOWN;
    }

    public long getIconId() {
        return this.getLong(VirtualServerProperty.VIRTUALSERVER_ICON_ID);
    }

    public String getIp() {
        return this.get(VirtualServerProperty.VIRTUALSERVER_IP);
    }

    public long getKeepAliveBytesReceived() {
        return this.getLong(VirtualServerProperty.CONNECTION_BYTES_RECEIVED_KEEPALIVE);
    }

    public long getKeepAliveBytesSent() {
        return this.getLong(VirtualServerProperty.CONNECTION_BYTES_SENT_KEEPALIVE);
    }

    public long getKeepAlivePacketsReceived() {
        return this.getLong(VirtualServerProperty.CONNECTION_PACKETS_RECEIVED_KEEPALIVE);
    }

    public long getKeepAlivePacketsSent() {
        return this.getLong(VirtualServerProperty.CONNECTION_PACKETS_SENT_KEEPALIVE);
    }

    public String getMachineId() {
        return this.get(VirtualServerProperty.VIRTUALSERVER_MACHINE_ID);
    }

    public long getMaxDownloadBandwidth() {
        return this.getLong(VirtualServerProperty.VIRTUALSERVER_MAX_DOWNLOAD_TOTAL_BANDWIDTH);
    }

    public long getMaxUploadBandwidth() {
        return this.getLong(VirtualServerProperty.VIRTUALSERVER_MAX_UPLOAD_TOTAL_BANDWIDTH);
    }

    public int getMinClientsInChannelBeforeForcedSilence() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_MIN_CLIENTS_IN_CHANNEL_BEFORE_FORCED_SILENCE);
    }

    public int getMinimumClientVersion() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_MIN_CLIENT_VERSION);
    }

    public long getMonthlyBytesDownloaded() {
        return this.getLong(VirtualServerProperty.VIRTUALSERVER_MONTH_BYTES_DOWNLOADED);
    }

    public long getMonthlyBytesUploaded() {
        return this.getLong(VirtualServerProperty.VIRTUALSERVER_MONTH_BYTES_UPLOADED);
    }

    public int getNeededIdentitySecurityLevel() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_NEEDED_IDENTITY_SECURITY_LEVEL);
    }

    public String getPassword() {
        return this.get(VirtualServerProperty.VIRTUALSERVER_PASSWORD);
    }

    public String getPhoneticName() {
        return this.get(VirtualServerProperty.VIRTUALSERVER_NAME_PHONETIC);
    }

    public double getPing() {
        return this.getDouble(VirtualServerProperty.VIRTUALSERVER_TOTAL_PING);
    }

    public String getPlatform() {
        return this.get(VirtualServerProperty.VIRTUALSERVER_PLATFORM);
    }

    public double getPrioritySpeakerDimmModificator() {
        return this.getDouble(VirtualServerProperty.VIRTUALSERVER_PRIORITY_SPEAKER_DIMM_MODIFICATOR);
    }

    public int getReservedSlots() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_RESERVED_SLOTS);
    }

    public long getSpeechBytesReceived() {
        return this.getLong(VirtualServerProperty.CONNECTION_BYTES_RECEIVED_SPEECH);
    }

    public long getSpeechBytesSent() {
        return this.getLong(VirtualServerProperty.CONNECTION_BYTES_SENT_SPEECH);
    }

    public long getSpeechPacketsReceived() {
        return this.getLong(VirtualServerProperty.CONNECTION_PACKETS_RECEIVED_SPEECH);
    }

    public long getSpeechPacketsSent() {
        return this.getLong(VirtualServerProperty.CONNECTION_PACKETS_SENT_SPEECH);
    }

    public long getTotalBytesDownloaded() {
        return this.getLong(VirtualServerProperty.VIRTUALSERVER_TOTAL_BYTES_DOWNLOADED);
    }

    public long getTotalBytesReceived() {
        return this.getLong(VirtualServerProperty.CONNECTION_BYTES_RECEIVED_TOTAL);
    }

    public long getTotalBytesSent() {
        return this.getLong(VirtualServerProperty.CONNECTION_BYTES_SENT_TOTAL);
    }

    public long getTotalBytesUploaded() {
        return this.getLong(VirtualServerProperty.VIRTUALSERVER_TOTAL_BYTES_UPLOADED);
    }

    public int getTotalClientConnections() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_CLIENT_CONNECTIONS);
    }

    public double getTotalControlPacketloss() {
        return this.getDouble(VirtualServerProperty.VIRTUALSERVER_TOTAL_PACKETLOSS_CONTROL);
    }

    public double getTotalKeepAlivePacketloss() {
        return this.getDouble(VirtualServerProperty.VIRTUALSERVER_TOTAL_PACKETLOSS_KEEPALIVE);
    }

    public double getTotalPacketloss() {
        return this.getDouble(VirtualServerProperty.VIRTUALSERVER_TOTAL_PACKETLOSS_TOTAL);
    }

    public long getTotalPacketsReceived() {
        return this.getLong(VirtualServerProperty.CONNECTION_PACKETS_RECEIVED_TOTAL);
    }

    public long getTotalPacketsSent() {
        return this.getLong(VirtualServerProperty.CONNECTION_PACKETS_SENT_TOTAL);
    }

    public int getTotalQueryClientConnections() {
        return this.getInt(VirtualServerProperty.VIRTUALSERVER_QUERY_CLIENT_CONNECTIONS);
    }

    public double getTotalSpeechPacketloss() {
        return this.getDouble(VirtualServerProperty.VIRTUALSERVER_TOTAL_PACKETLOSS_SPEECH);
    }

    public long getUploadQuota() {
        return this.getLong(VirtualServerProperty.VIRTUALSERVER_UPLOAD_QUOTA);
    }

    public String getVersion() {
        return this.get(VirtualServerProperty.VIRTUALSERVER_VERSION);
    }

    public String getWelcomeMessage() {
        return this.get(VirtualServerProperty.VIRTUALSERVER_WELCOMEMESSAGE);
    }

    public boolean hasPassword() {
        return this.getBoolean(VirtualServerProperty.VIRTUALSERVER_FLAG_PASSWORD);
    }

    public boolean isAskingPrivilegeKey() {
        return this.getBoolean(VirtualServerProperty.VIRTUALSERVER_ASK_FOR_PRIVILEGEKEY);
    }

    public boolean isLoggingChannel() {
        return this.getBoolean(VirtualServerProperty.VIRTUALSERVER_LOG_CHANNEL);
    }

    public boolean isLoggingClient() {
        return this.getBoolean(VirtualServerProperty.VIRTUALSERVER_LOG_CLIENT);
    }

    public boolean isLoggingFileTransfer() {
        return this.getBoolean(VirtualServerProperty.VIRTUALSERVER_LOG_FILETRANSFER);
    }

    public boolean isLoggingPermissions() {
        return this.getBoolean(VirtualServerProperty.VIRTUALSERVER_LOG_PERMISSIONS);
    }

    public boolean isLoggingQuery() {
        return this.getBoolean(VirtualServerProperty.VIRTUALSERVER_LOG_QUERY);
    }

    public boolean isLoggingServer() {
        return this.getBoolean(VirtualServerProperty.VIRTUALSERVER_LOG_SERVER);
    }

    public boolean isWeblistEnabled() {
        return this.getBoolean(VirtualServerProperty.VIRTUALSERVER_WEBLIST_ENABLED);
    }
}

