/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.api.wrapper;

import com.github.theholywaffle.teamspeak3.api.ChannelProperty;
import com.github.theholywaffle.teamspeak3.api.wrapper.ChannelBase;
import java.util.Map;
import java.util.UUID;

public class ChannelInfo
extends ChannelBase {
    private final int channelId;

    public ChannelInfo(int channelId, Map<String, String> map) {
        super(map);
        this.channelId = channelId;
    }

    @Override
    public int getId() {
        return this.channelId;
    }

    public String getDescription() {
        return this.get(ChannelProperty.CHANNEL_DESCRIPTION);
    }

    public String getPassword() {
        return this.get(ChannelProperty.CHANNEL_PASSWORD);
    }

    public int getCodecLatencyFactor() {
        return this.getInt(ChannelProperty.CHANNEL_CODEC_LATENCY_FACTOR);
    }

    public UUID getUniqueIdentifier() {
        return UUID.fromString(this.get(ChannelProperty.CHANNEL_UNIQUE_IDENTIFIER));
    }

    public boolean isEncrypted() {
        return !this.getBoolean(ChannelProperty.CHANNEL_CODEC_IS_UNENCRYPTED);
    }

    public boolean hasUnlimitedClients() {
        return this.getBoolean(ChannelProperty.CHANNEL_FLAG_MAXCLIENTS_UNLIMITED);
    }

    public boolean hasUnlimitedFamilyClients() {
        return this.getBoolean(ChannelProperty.CHANNEL_FLAG_MAXFAMILYCLIENTS_UNLIMITED);
    }

    public boolean hasInheritedMaxFamilyClients() {
        return this.getBoolean(ChannelProperty.CHANNEL_FLAG_MAXFAMILYCLIENTS_INHERITED);
    }

    public String getFilePath() {
        return this.get(ChannelProperty.CHANNEL_FILEPATH);
    }

    public boolean isForcedSilence() {
        return this.getBoolean(ChannelProperty.CHANNEL_FORCED_SILENCE);
    }

    public String getPhoneticName() {
        return this.get(ChannelProperty.CHANNEL_NAME_PHONETIC);
    }

    @Override
    public boolean isFamilyEmpty() {
        return this.getSecondsEmpty() >= 0;
    }
}

