/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.CommandQueue;
import com.github.theholywaffle.teamspeak3.Connection;
import com.github.theholywaffle.teamspeak3.EventManager;
import com.github.theholywaffle.teamspeak3.FileTransferHelper;
import com.github.theholywaffle.teamspeak3.TS3Api;
import com.github.theholywaffle.teamspeak3.TS3ApiAsync;
import com.github.theholywaffle.teamspeak3.TS3Config;
import com.github.theholywaffle.teamspeak3.api.exception.TS3ConnectionFailedException;
import com.github.theholywaffle.teamspeak3.api.exception.TS3QueryShutDownException;
import com.github.theholywaffle.teamspeak3.api.reconnect.ConnectionHandler;
import com.github.theholywaffle.teamspeak3.api.reconnect.DisconnectingConnectionHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TS3Query {
    private static final Logger log = LoggerFactory.getLogger(TS3Query.class);
    private final ConnectionHandler connectionHandler;
    private final EventManager eventManager;
    private final ExecutorService userThreadPool;
    private final FileTransferHelper fileTransferHelper;
    private final CommandQueue globalQueue;
    private final TS3Config config;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private Connection connection;

    public TS3Query() {
        this(new TS3Config());
    }

    public TS3Query(TS3Config config) {
        this.config = config.freeze();
        this.eventManager = new EventManager(this);
        this.userThreadPool = Executors.newCachedThreadPool();
        this.fileTransferHelper = new FileTransferHelper(config.getHost());
        this.connectionHandler = config.getReconnectStrategy().create(config.getConnectionHandler());
        this.globalQueue = CommandQueue.newGlobalQueue(this, this.connectionHandler instanceof DisconnectingConnectionHandler);
    }

    public void connect() {
        if (Thread.holdsLock(this)) {
            throw new IllegalStateException("Cannot call connect from onConnect handler");
        }
        this.doConnect();
    }

    private synchronized void doConnect() {
        if (this.userThreadPool.isShutdown()) {
            throw new IllegalStateException("The query has already been shut down");
        }
        this.disconnect();
        try {
            CommandQueue queue = CommandQueue.newConnectQueue(this);
            Connection con = new Connection(this, this.config, queue);
            try {
                TS3Api api = queue.getApi();
                if (this.config.getProtocol() == Protocol.RAW && this.config.hasLoginCredentials()) {
                    api.login(this.config.getUsername(), this.config.getPassword());
                }
                this.connectionHandler.onConnect(api);
            }
            catch (TS3QueryShutDownException e) {
                queue.failRemainingCommands();
                throw new TS3ConnectionFailedException(e);
            }
            catch (Exception e) {
                con.disconnect();
                queue.failRemainingCommands();
                throw new TS3ConnectionFailedException("ConnectionHandler threw exception in connect handler", e);
            }
            queue.shutDown();
            this.connection = con;
            con.setCommandQueue(this.globalQueue);
            this.connected.set(true);
        }
        catch (TS3ConnectionFailedException conFailed) {
            if (this.connection == null) {
                this.shutDown();
            }
            throw conFailed;
        }
    }

    public void exit() {
        if (Thread.holdsLock(this)) {
            throw new IllegalStateException("Cannot call exit from onConnect handler");
        }
        try {
            this.globalQueue.quit();
        }
        finally {
            this.shutDown();
        }
    }

    private synchronized void shutDown() {
        if (this.userThreadPool.isShutdown()) {
            return;
        }
        this.disconnect();
        this.globalQueue.failRemainingCommands();
        this.userThreadPool.shutdown();
    }

    private synchronized void disconnect() {
        if (this.connection == null) {
            return;
        }
        this.connection.disconnect();
        this.connected.set(false);
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    public TS3Api getApi() {
        return this.globalQueue.getApi();
    }

    public TS3ApiAsync getAsyncApi() {
        return this.globalQueue.getAsyncApi();
    }

    void submitUserTask(String name, Runnable task) {
        this.userThreadPool.submit(() -> {
            try {
                task.run();
            }
            catch (Throwable throwable) {
                log.error(name + " threw an exception", throwable);
            }
        });
    }

    EventManager getEventManager() {
        return this.eventManager;
    }

    FileTransferHelper getFileTransferHelper() {
        return this.fileTransferHelper;
    }

    void fireDisconnect() {
        this.connected.set(false);
        this.submitUserTask("ConnectionHandler disconnect task", this::handleDisconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisconnect() {
        try {
            this.connectionHandler.onDisconnect(this);
        }
        finally {
            TS3Query tS3Query = this;
            synchronized (tS3Query) {
                if (!this.connected.get()) {
                    this.shutDown();
                }
            }
        }
    }

    public static enum Protocol {
        RAW,
        SSH;

    }

    public static class FloodRate {
        public static final FloodRate DEFAULT = new FloodRate(350);
        public static final FloodRate UNLIMITED = new FloodRate(0);
        private final int ms;

        public static FloodRate custom(int milliseconds) {
            if (milliseconds < 0) {
                throw new IllegalArgumentException("Timeout must be positive");
            }
            return new FloodRate(milliseconds);
        }

        private FloodRate(int ms) {
            this.ms = ms;
        }

        public int getMs() {
            return this.ms;
        }
    }
}

