/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.reconnect.ConnectionHandler;
import com.github.theholywaffle.teamspeak3.api.reconnect.ReconnectStrategy;

public class TS3Config {
    private boolean frozen = false;
    private String host = null;
    private int queryPort = -1;
    private TS3Query.Protocol protocol = TS3Query.Protocol.RAW;
    private String username = null;
    private String password = null;
    private TS3Query.FloodRate floodRate = TS3Query.FloodRate.DEFAULT;
    private boolean enableCommunicationsLogging = false;
    private int commandTimeout = 4000;
    private ReconnectStrategy reconnectStrategy = ReconnectStrategy.disconnect();
    private ConnectionHandler connectionHandler = null;

    public TS3Config setHost(String host) {
        this.checkFrozen();
        this.host = host;
        return this;
    }

    String getHost() {
        return this.host;
    }

    public TS3Config setQueryPort(int queryPort) {
        this.checkFrozen();
        if (queryPort <= 0 || queryPort > 65535) {
            throw new IllegalArgumentException("Port out of range: " + queryPort);
        }
        this.queryPort = queryPort;
        return this;
    }

    int getQueryPort() {
        if (this.queryPort > 0) {
            return this.queryPort;
        }
        return this.protocol == TS3Query.Protocol.SSH ? 10022 : 10011;
    }

    public TS3Config setProtocol(TS3Query.Protocol protocol) {
        this.checkFrozen();
        if (protocol == null) {
            throw new IllegalArgumentException("protocol cannot be null!");
        }
        this.protocol = protocol;
        return this;
    }

    TS3Query.Protocol getProtocol() {
        return this.protocol;
    }

    public TS3Config setLoginCredentials(String username, String password) {
        this.checkFrozen();
        this.username = username;
        this.password = password;
        return this;
    }

    boolean hasLoginCredentials() {
        return this.username != null && this.password != null;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    public TS3Config setFloodRate(TS3Query.FloodRate rate) {
        this.checkFrozen();
        if (rate == null) {
            throw new IllegalArgumentException("rate cannot be null!");
        }
        this.floodRate = rate;
        return this;
    }

    TS3Query.FloodRate getFloodRate() {
        return this.floodRate;
    }

    public TS3Config setEnableCommunicationsLogging(boolean enable) {
        this.checkFrozen();
        this.enableCommunicationsLogging = enable;
        return this;
    }

    boolean getEnableCommunicationsLogging() {
        return this.enableCommunicationsLogging;
    }

    public TS3Config setCommandTimeout(int commandTimeout) {
        this.checkFrozen();
        if (commandTimeout <= 0) {
            throw new IllegalArgumentException("Timeout value must be greater than 0");
        }
        this.commandTimeout = commandTimeout;
        return this;
    }

    int getCommandTimeout() {
        return this.commandTimeout;
    }

    public TS3Config setReconnectStrategy(ReconnectStrategy reconnectStrategy) {
        this.checkFrozen();
        if (reconnectStrategy == null) {
            throw new IllegalArgumentException("reconnectStrategy cannot be null!");
        }
        this.reconnectStrategy = reconnectStrategy;
        return this;
    }

    ReconnectStrategy getReconnectStrategy() {
        return this.reconnectStrategy;
    }

    public TS3Config setConnectionHandler(ConnectionHandler connectionHandler) {
        this.checkFrozen();
        this.connectionHandler = connectionHandler;
        return this;
    }

    ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    TS3Config freeze() {
        this.frozen = true;
        return this;
    }

    private void checkFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("TS3Config cannot be modified after being used to create a TS3Query. Please make any changes to TS3Config *before* calling TS3Query's constructor.");
        }
    }
}

