/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.Connection;
import com.github.theholywaffle.teamspeak3.TS3Config;
import com.github.theholywaffle.teamspeak3.commands.Command;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamWriter
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(StreamWriter.class);
    private final Connection con;
    private final PrintWriter out;
    private final int floodRate;
    private final boolean logComms;

    StreamWriter(Connection connection, OutputStream outStream, TS3Config config) {
        super("[TeamSpeak-3-Java-API] StreamWriter");
        this.con = connection;
        this.out = new PrintWriter((Writer)new OutputStreamWriter(outStream, StandardCharsets.UTF_8), true);
        this.floodRate = config.getFloodRate().getMs();
        this.logComms = config.getEnableCommunicationsLogging();
    }

    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                Command command;
                if (this.floodRate > 0) {
                    Thread.sleep(this.floodRate);
                }
                if ((command = this.con.getCommandQueue().transferCommand()) == null) continue;
                this.con.resetIdleTime();
                String message = command.toString();
                if (this.logComms) {
                    log.debug("[{}] > {}", (Object)command.getName(), (Object)message);
                }
                this.out.println(message);
            }
        }
        catch (InterruptedException e) {
            this.interrupt();
        }
        this.out.close();
        if (!this.isInterrupted()) {
            log.warn("StreamWriter has stopped!");
            this.con.internalDisconnect();
        }
    }
}

