/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.CommandQueue;
import com.github.theholywaffle.teamspeak3.Connection;
import com.github.theholywaffle.teamspeak3.TS3Config;
import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.CommandFuture;
import com.github.theholywaffle.teamspeak3.api.exception.TS3CommandFailedException;
import com.github.theholywaffle.teamspeak3.api.wrapper.QueryError;
import com.github.theholywaffle.teamspeak3.commands.Command;
import com.github.theholywaffle.teamspeak3.commands.response.DefaultArrayResponse;
import com.github.theholywaffle.teamspeak3.commands.response.ResponseBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamReader
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(StreamReader.class);
    private final TS3Query ts3;
    private final Connection con;
    private final BufferedReader in;
    private final boolean logComms;
    private CommandQueue commandQueue = null;
    private ResponseBuilder responseBuilder = null;
    private String lastEvent = "";

    StreamReader(Connection connection, InputStream inStream, TS3Query query, TS3Config config) throws IOException {
        super("[TeamSpeak-3-Java-API] StreamReader");
        this.ts3 = query;
        this.con = connection;
        this.in = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));
        this.logComms = config.getEnableCommunicationsLogging();
        this.readWelcomeMessage();
    }

    private void readWelcomeMessage() throws IOException {
        for (int i = 0; i < 4 || this.in.ready(); ++i) {
            String welcomeMessage = this.in.readLine();
            if (!this.logComms) continue;
            log.debug("< {}", (Object)welcomeMessage);
        }
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            String line;
            try {
                line = this.in.readLine();
            }
            catch (SocketTimeoutException socketTimeout) {
                if (!this.con.isTimedOut()) continue;
                log.error("Connection timed out.", (Throwable)socketTimeout);
                break;
            }
            catch (IOException io) {
                if (this.isInterrupted()) break;
                log.error("Connection error occurred.", (Throwable)io);
                break;
            }
            if (line == null) {
                log.error("Connection closed by the server.");
                break;
            }
            if (line.isEmpty()) continue;
            if (line.startsWith("notify")) {
                this.handleEvent(line);
                continue;
            }
            this.con.resetIdleTime();
            this.handleCommandResponse(line);
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.isInterrupted()) {
            this.con.internalDisconnect();
        }
    }

    private void handleEvent(String event) {
        if (this.logComms) {
            log.debug("[event] < {}", (Object)event);
        }
        if (this.isDuplicate(event)) {
            return;
        }
        String[] arr = event.split(" ", 2);
        this.ts3.getEventManager().fireEvent(arr[0], arr[1]);
    }

    private void handleCommandResponse(String response) {
        if (this.responseBuilder == null) {
            this.commandQueue = this.con.getCommandQueue();
            Command command = this.commandQueue.peekReceiveQueue();
            if (command == null) {
                log.warn("[UNHANDLED] < {}", (Object)response);
                return;
            }
            this.responseBuilder = new ResponseBuilder(command);
        }
        if (this.logComms) {
            log.debug("[{}] < {}", (Object)this.responseBuilder.getCommand().getName(), (Object)response);
        }
        if (response.startsWith("error ")) {
            this.handleCommandError(this.responseBuilder, response);
            this.commandQueue.removeFromReceiveQueue();
            this.responseBuilder = null;
        } else {
            this.responseBuilder.appendResponse(response);
        }
    }

    private void handleCommandError(ResponseBuilder responseBuilder, String error) {
        Command command = responseBuilder.getCommand();
        if (command.getName().equals("quit")) {
            this.interrupt();
        }
        QueryError queryError = DefaultArrayResponse.parseError(error);
        CommandFuture<DefaultArrayResponse> future = command.getFuture();
        if (queryError.isSuccessful()) {
            DefaultArrayResponse response = responseBuilder.buildResponse();
            this.ts3.submitUserTask("Future SuccessListener (" + command.getName() + ")", () -> future.set(response));
        } else {
            log.debug("TS3 command error: {}", (Object)queryError);
            this.ts3.submitUserTask("Future FailureListener (" + command.getName() + ")", () -> future.fail(new TS3CommandFailedException(queryError, command.getName())));
        }
    }

    private boolean isDuplicate(String eventMessage) {
        if (!(eventMessage.startsWith("notifyclientmoved") || eventMessage.startsWith("notifycliententerview") || eventMessage.startsWith("notifyclientleftview"))) {
            return false;
        }
        if (eventMessage.equals(this.lastEvent)) {
            this.lastEvent = "";
            return true;
        }
        this.lastEvent = eventMessage;
        return false;
    }
}

