/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.Connection;
import com.github.theholywaffle.teamspeak3.TS3ApiAsync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeepAlive
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(KeepAlive.class);
    private static final int SLEEP = 60000;
    private final Connection con;

    public KeepAlive(Connection connection) {
        super("[TeamSpeak-3-Java-API] KeepAlive");
        this.con = connection;
    }

    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                long idleTime = this.con.getIdleTime();
                if (idleTime >= 60000L) {
                    TS3ApiAsync asyncApi = this.con.getCommandQueue().getAsyncApi();
                    asyncApi.whoAmI().await();
                    continue;
                }
                Thread.sleep(60000L - idleTime);
            }
        }
        catch (InterruptedException idleTime) {
        }
        catch (Exception e) {
            log.warn("KeepAlive thread has stopped!", (Throwable)e);
            this.con.internalDisconnect();
        }
    }
}

