/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.event.ChannelCreateEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelDeletedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelDescriptionEditedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelEditedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelMovedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ChannelPasswordChangedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ClientJoinEvent;
import com.github.theholywaffle.teamspeak3.api.event.ClientLeaveEvent;
import com.github.theholywaffle.teamspeak3.api.event.ClientMovedEvent;
import com.github.theholywaffle.teamspeak3.api.event.PrivilegeKeyUsedEvent;
import com.github.theholywaffle.teamspeak3.api.event.ServerEditedEvent;
import com.github.theholywaffle.teamspeak3.api.event.TS3Event;
import com.github.theholywaffle.teamspeak3.api.event.TS3Listener;
import com.github.theholywaffle.teamspeak3.api.event.TextMessageEvent;
import com.github.theholywaffle.teamspeak3.api.exception.TS3UnknownEventException;
import com.github.theholywaffle.teamspeak3.api.wrapper.Wrapper;
import com.github.theholywaffle.teamspeak3.commands.response.DefaultArrayResponse;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventManager {
    private static final Logger log = LoggerFactory.getLogger(EventManager.class);
    private static final Map<String, Function<Wrapper, TS3Event>> eventByName = new HashMap<String, Function<Wrapper, TS3Event>>(12);
    private final Collection<ListenerTask> tasks = new CopyOnWriteArrayList<ListenerTask>();
    private final TS3Query ts3;

    EventManager(TS3Query query) {
        this.ts3 = query;
    }

    void addListeners(TS3Listener ... listeners) {
        for (TS3Listener listener : listeners) {
            if (listener == null) {
                throw new IllegalArgumentException("A listener was null");
            }
            ListenerTask task = new ListenerTask(listener);
            this.tasks.add(task);
        }
    }

    void removeListeners(TS3Listener ... listeners) {
        List<TS3Listener> listenersToRemove = Arrays.asList(listeners);
        this.tasks.removeIf(listenerTask -> listenersToRemove.contains(((ListenerTask)listenerTask).listener));
    }

    void fireEvent(String notifyName, String notifyBody) {
        DefaultArrayResponse response = DefaultArrayResponse.parse(notifyBody);
        for (Wrapper eventData : response.getResponses()) {
            TS3Event event = EventManager.createEvent(notifyName, eventData);
            this.fireEvent(event);
        }
    }

    void fireEvent(TS3Event event) {
        if (event == null) {
            throw new IllegalArgumentException("TS3Event was null");
        }
        for (ListenerTask task : this.tasks) {
            task.enqueueEvent(event);
        }
    }

    private static TS3Event createEvent(String notifyName, Wrapper eventData) {
        Function<Wrapper, TS3Event> constructor = eventByName.get(notifyName);
        if (constructor == null) {
            throw new TS3UnknownEventException(notifyName + " " + eventData);
        }
        return constructor.apply(eventData);
    }

    static {
        eventByName.put("notifytextmessage", TextMessageEvent::new);
        eventByName.put("notifycliententerview", ClientJoinEvent::new);
        eventByName.put("notifyclientleftview", ClientLeaveEvent::new);
        eventByName.put("notifyserveredited", ServerEditedEvent::new);
        eventByName.put("notifychanneledited", ChannelEditedEvent::new);
        eventByName.put("notifychanneldescriptionchanged", ChannelDescriptionEditedEvent::new);
        eventByName.put("notifyclientmoved", ClientMovedEvent::new);
        eventByName.put("notifychannelcreated", ChannelCreateEvent::new);
        eventByName.put("notifychanneldeleted", ChannelDeletedEvent::new);
        eventByName.put("notifychannelmoved", ChannelMovedEvent::new);
        eventByName.put("notifychannelpasswordchanged", ChannelPasswordChangedEvent::new);
        eventByName.put("notifytokenused", PrivilegeKeyUsedEvent::new);
    }

    private class ListenerTask
    implements Runnable {
        private static final int START_QUEUE_SIZE = 16;
        private final TS3Listener listener;
        private final Queue<TS3Event> eventQueue;

        ListenerTask(TS3Listener ts3Listener) {
            this.listener = ts3Listener;
            this.eventQueue = new ArrayDeque<TS3Event>(16);
        }

        TS3Listener getListener() {
            return this.listener;
        }

        synchronized void enqueueEvent(TS3Event event) {
            if (this.eventQueue.isEmpty()) {
                this.eventQueue.add(event);
                EventManager.this.ts3.submitUserTask("Event listener task", this);
            } else {
                this.eventQueue.add(event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TS3Event currentEvent;
            ListenerTask listenerTask = this;
            synchronized (listenerTask) {
                currentEvent = this.eventQueue.peek();
                if (currentEvent == null) {
                    throw new IllegalStateException("Task started without events");
                }
            }
            do {
                try {
                    currentEvent.fire(this.listener);
                }
                catch (Throwable throwable) {
                    log.error("Event listener threw an exception", throwable);
                }
                listenerTask = this;
                synchronized (listenerTask) {
                    this.eventQueue.remove();
                    currentEvent = this.eventQueue.peek();
                }
            } while (currentEvent != null);
        }
    }
}

