/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.TS3Api;
import com.github.theholywaffle.teamspeak3.TS3ApiAsync;
import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.exception.TS3QueryShutDownException;
import com.github.theholywaffle.teamspeak3.commands.Command;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class CommandQueue {
    private static final int INITIAL_QUEUE_SIZE = 16;
    private final Queue<Command> sendQueue;
    private final Queue<Command> receiveQueue;
    private final Lock queueLock;
    private final Condition canTransfer;
    private final TS3Api api;
    private final TS3ApiAsync asyncApi;
    private final boolean unlimitedInFlightCommands;
    private final boolean isGlobal;
    private boolean rejectNew = false;
    private long firstEnqueueTimeAfterEmpty;

    static CommandQueue newGlobalQueue(TS3Query query, boolean unlimited) {
        return new CommandQueue(query, true, unlimited);
    }

    static CommandQueue newConnectQueue(TS3Query query) {
        return new CommandQueue(query, false, true);
    }

    private CommandQueue(TS3Query query, boolean global, boolean unlimited) {
        this.isGlobal = global;
        this.unlimitedInFlightCommands = unlimited;
        this.sendQueue = new ArrayDeque<Command>(16);
        this.receiveQueue = new ArrayDeque<Command>(unlimited ? 16 : 1);
        this.queueLock = new ReentrantLock();
        this.canTransfer = this.queueLock.newCondition();
        this.asyncApi = new TS3ApiAsync(query, this);
        this.api = new TS3Api(this.asyncApi);
    }

    TS3Api getApi() {
        return this.api;
    }

    TS3ApiAsync getAsyncApi() {
        return this.asyncApi;
    }

    boolean isGlobal() {
        return this.isGlobal;
    }

    void enqueueCommand(Command command) {
        this.queueLock.lock();
        try {
            if (this.rejectNew) {
                command.getFuture().fail(new TS3QueryShutDownException());
                return;
            }
            if (this.isEmpty()) {
                this.firstEnqueueTimeAfterEmpty = System.currentTimeMillis();
            }
            this.sendQueue.add(command);
            this.canTransfer.signalAll();
        }
        finally {
            this.queueLock.unlock();
        }
    }

    Command transferCommand() throws InterruptedException {
        this.queueLock.lockInterruptibly();
        try {
            while (this.sendQueue.isEmpty() || !this.receiveQueue.isEmpty() && !this.unlimitedInFlightCommands) {
                if (this.sendQueue.isEmpty() && this.rejectNew) {
                    Command command = null;
                    return command;
                }
                this.canTransfer.await();
            }
            Command command = this.sendQueue.remove();
            this.receiveQueue.add(command);
            Command command2 = command;
            return command2;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    Command peekReceiveQueue() {
        this.queueLock.lock();
        try {
            Command command = this.receiveQueue.peek();
            return command;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    void removeFromReceiveQueue() {
        this.queueLock.lock();
        try {
            if (this.receiveQueue.isEmpty()) {
                throw new IllegalStateException("Empty receive queue");
            }
            this.receiveQueue.remove();
            this.canTransfer.signalAll();
        }
        finally {
            this.queueLock.unlock();
        }
    }

    void resetSentCommands() {
        this.queueLock.lock();
        try {
            Collection<Command> allCommands = this.getAllCommands();
            this.sendQueue.clear();
            this.receiveQueue.clear();
            this.sendQueue.addAll(allCommands);
            this.rejectNew = false;
            this.firstEnqueueTimeAfterEmpty = System.currentTimeMillis();
            this.canTransfer.signalAll();
        }
        finally {
            this.queueLock.unlock();
        }
    }

    boolean isEmpty() {
        this.queueLock.lock();
        try {
            boolean bl = this.receiveQueue.isEmpty() && this.sendQueue.isEmpty();
            return bl;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    long getBusyTime() {
        this.queueLock.lock();
        try {
            if (this.isEmpty()) {
                long l = 0L;
                return l;
            }
            long l = System.currentTimeMillis() - this.firstEnqueueTimeAfterEmpty;
            return l;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    void shutDown() {
        this.queueLock.lock();
        try {
            this.rejectNew = true;
            this.canTransfer.signalAll();
            while (!this.isEmpty()) {
                this.canTransfer.awaitUninterruptibly();
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    void quit() {
        this.queueLock.lock();
        try {
            if (!this.rejectNew) {
                this.asyncApi.quit();
            }
            this.shutDown();
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failRemainingCommands() {
        this.queueLock.lock();
        try {
            this.rejectNew = true;
            this.canTransfer.signalAll();
            Collection<Command> allCommands = this.getAllCommands();
            for (Command command : allCommands) {
                command.getFuture().fail(new TS3QueryShutDownException());
            }
            this.sendQueue.clear();
            this.receiveQueue.clear();
        }
        finally {
            this.queueLock.unlock();
        }
    }

    private Collection<Command> getAllCommands() {
        ArrayList<Command> allCommands = new ArrayList<Command>(this.sendQueue.size() + this.receiveQueue.size());
        allCommands.addAll(this.sendQueue);
        allCommands.addAll(this.receiveQueue);
        return allCommands;
    }
}

